/*
 * Copyright (c) 2002-2015 Oracle and/or its affiliates. All rights reserved.
 */

package javasoft.sqe.tests.javax.mail.internet.MimeBodyPart;

import java.util.*;
import java.io.*;
import javax.mail.*;
import javax.mail.internet.*;
import com.sun.javatest.*;
import javasoft.sqe.tests.javax.mail.util.MailTest;

/**
 * This class tests the <strong>setFileName()</strong> API.
 * It does by passing various valid input values and then checking
 * the type of the returned object.	<p>
 *
 *		Set the filename associated with BodyPart. <p>
 * api2test: public void setFileName(String)  <p>
 *
 * how2test: Call API with string arguments, then call getFileName(), if the
 *	     set/get values are equal then testcase passes, otherwise it fails.
 */

public class setFileName_Test extends MailTest {

    public static String[] setfn = { "fooabc!@#$%^&!xzy","/user/foo/testfile",":A:B:FOOTEST" };

    public static void main( String argv[] )
    {
        setFileName_Test test = new setFileName_Test();
        Status s = test.run(argv, System.err, System.out);
	s.exit();
    }

    public Status run(String argv[], PrintWriter log, PrintWriter out)
    {
	super.run(argv, log, out);
	parseArgs(argv);	// parse command-line options

        out.println("\nTesting class MimeBodyPart: setFileName()\n");

        try {
          // Create a MimeBodyPart object
	     MimeBodyPart bp = new MimeBodyPart();

             if( bp == null )
                 return Status.failed("Failed to create MimeBodyPart object!");

	  // BEGIN UNIT TEST:

             for( int i = 0; i < setfn.length; i++ )
             {
                  out.println("UNIT TEST "+i+": setFileName("+setfn[i]+")");
		  bp.setFileName(setfn[i]); 	// API TEST

                  if( setfn[i].equals(bp.getFileName()) )
                      out.println("UNIT TEST "+i+":  passed.\n");
                  else {
                        out.println("UNIT TEST "+i+":  FAILED.\n");
                        errors++;
                  }
             }
          // END UNIT TEST:
	     checkStatus();

        } catch ( Exception e ) {
	     handlException(e);
        }
	return status;
     }
}
