/*
 * Decompiled with CFR 0.152.
 */
package org.freebxml.omar.common.security;

import com.sun.org.apache.xml.security.exceptions.AlgorithmAlreadyRegisteredException;
import com.sun.org.apache.xml.security.transforms.Transform;
import com.sun.org.apache.xml.security.transforms.TransformationException;
import com.sun.org.apache.xml.security.transforms.Transforms;
import com.sun.org.apache.xml.security.utils.resolver.ResourceResolver;
import com.sun.org.apache.xpath.internal.XPathAPI;
import com.sun.xml.wss.KeyInfoStrategy;
import com.sun.xml.wss.MessageFilter;
import com.sun.xml.wss.SecurableSoapMessage;
import com.sun.xml.wss.SignatureHeaderBlock;
import com.sun.xml.wss.Target;
import com.sun.xml.wss.XMLUtil;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.filter.FilterBase;
import com.sun.xml.wss.helpers.ResolverId;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import javax.xml.namespace.QName;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import javax.xml.transform.TransformerException;
import org.freebxml.omar.common.security.ExtendedSignatureHeaderBlock;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ExtendedSignFilter
extends FilterBase
implements MessageFilter {
    private String strTransformXpath;
    private String x509TokenId;
    static /* synthetic */ Class class$org$freebxml$omar$common$security$TransformAttachmentContentOnly;

    private static void registerTransforms() {
        try {
            String transformURI = "http://docs.oasis-open.org/wss/2004/XX/oasis-2004XX-wss-swa-profile-1.0#Attachment-Content-Only-Transform";
            Transform.register((String)transformURI, (String)(class$org$freebxml$omar$common$security$TransformAttachmentContentOnly == null ? (class$org$freebxml$omar$common$security$TransformAttachmentContentOnly = ExtendedSignFilter.class$("org.freebxml.omar.common.security.TransformAttachmentContentOnly")) : class$org$freebxml$omar$common$security$TransformAttachmentContentOnly).getName());
        }
        catch (AlgorithmAlreadyRegisteredException algorithmAlreadyRegisteredException) {
            // empty catch block
        }
    }

    public ExtendedSignFilter() {
        ExtendedSignFilter.registerTransforms();
    }

    public ExtendedSignFilter(KeyInfoStrategy keyInfoStrategy) throws XWSSecurityException {
        this("//S:Body", keyInfoStrategy);
    }

    public ExtendedSignFilter(String xpath, KeyInfoStrategy keyInfoStrategy) throws XWSSecurityException {
        if (xpath == null || keyInfoStrategy == null) {
            throw new XWSSecurityException("XPath and KeyInfoStrategy can not be null");
        }
        this.targets = new ArrayList();
        this.targets.add(new Target("xpath", xpath));
        this.keyInfoStrategy = keyInfoStrategy;
        ExtendedSignFilter.registerTransforms();
    }

    public ExtendedSignFilter(ArrayList targets, KeyInfoStrategy keyInfoStrategy) throws XWSSecurityException {
        if (targets == null || keyInfoStrategy == null) {
            throw new XWSSecurityException("Target List and KeyInfoStrategy can not be null");
        }
        this.targets = targets;
        this.keyInfoStrategy = keyInfoStrategy;
        ExtendedSignFilter.registerTransforms();
    }

    public void init() throws XWSSecurityException {
        if (this.getParameter("x509TokenId") != null) {
            this.x509TokenId = this.getParameter("x509TokenId");
        }
        if (this.getParameter("strtransformxpath") != null) {
            this.strTransformXpath = this.getParameter("strtransformxpath");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(SecurableSoapMessage secureMessage) throws XWSSecurityException {
        ExtendedSignatureHeaderBlock sigBlock = (ExtendedSignatureHeaderBlock)((Object)secureMessage.getFilterParameter("Signature"));
        if (null == sigBlock) {
            throw new XWSSecurityException("SIGNATURE_BLOCK filter parameter expected, not found");
        }
        this.keyInfoStrategy = (KeyInfoStrategy)secureMessage.getFilterParameter("KeyInfoStrategy");
        if (null == this.keyInfoStrategy) {
            throw new XWSSecurityException("KEYINFO_STRATEGY filter parameter expected, not found");
        }
        try {
            PrivateKey privKey = this.getAssociatedPrivateKey(secureMessage);
            if (privKey == null) {
                throw new XWSSecurityException("Couldn't locate private key for signing");
            }
            sigBlock.setSoapMessage((SOAPMessage)secureMessage);
            if (this.targets == null && this.strTransformXpath == null) {
                throw new XWSSecurityException("No Sign targets specified");
            }
            if (this.targets != null) {
                Iterator it = this.targets.iterator();
                while (it.hasNext()) {
                    Target target = (Target)it.next();
                    String targetType = target.getType();
                    String targetValue = target.getValue();
                    if (targetType.equals("qname")) {
                        this.addTransforms(sigBlock, secureMessage, this.convertToXpath(targetValue), false);
                        continue;
                    }
                    if (targetType.equals("xpath")) {
                        this.addTransforms(sigBlock, secureMessage, targetValue, false);
                        continue;
                    }
                    if (targetType.equals("uri") && targetValue.startsWith("cid:")) {
                        this.processAttachment(sigBlock, secureMessage, targetValue, this.createAttachmentTransforms(secureMessage));
                        continue;
                    }
                    if (!targetType.equals("uri")) continue;
                    Element elem = secureMessage.getElementById(targetValue);
                    this.processElement(sigBlock, secureMessage, elem, this.createTransforms(secureMessage, false));
                }
            }
            if (this.strTransformXpath != null) {
                this.addTransforms(sigBlock, secureMessage, this.strTransformXpath, true);
            }
            if (!SecurableSoapMessage.isWsuIdResolverAdded()) {
                ResourceResolver.registerAtStart((String)ResolverId.getResolverName());
                SecurableSoapMessage.setWsuIdResolverAdded((boolean)true);
            }
            sigBlock.sign(privKey);
        }
        finally {
            SecurableSoapMessage.removeDocMessageAssociation((Document)sigBlock.getOwnerDocument());
        }
    }

    private void addTransforms(SignatureHeaderBlock sigBlock, SecurableSoapMessage secureMessage, String xp, boolean signTokenFlag) throws XWSSecurityException {
        NodeList elemsToSign;
        SOAPPart soapPart = secureMessage.getSOAPPart();
        try {
            elemsToSign = XPathAPI.selectNodeList((Node)soapPart, xp, secureMessage.getNSContext());
        }
        catch (TransformerException e) {
            throw new XWSSecurityException((Throwable)e);
        }
        if (elemsToSign == null || elemsToSign.getLength() == 0) {
            throw new XWSSecurityException("No elements exist for xpath: " + xp);
        }
        for (int i = 0; i < elemsToSign.getLength(); ++i) {
            Transforms transforms = this.createTransforms(secureMessage, signTokenFlag);
            SOAPElement element = (SOAPElement)elemsToSign.item(i);
            this.processElement(sigBlock, secureMessage, (Element)element, transforms);
        }
        if (signTokenFlag) {
            SecurableSoapMessage.setDocMessageAssociation((Document)sigBlock.getOwnerDocument(), (SecurableSoapMessage)secureMessage);
        }
    }

    private String convertToXpath(String qname) {
        QName name = QName.valueOf(qname);
        if ("".equals(name.getNamespaceURI())) {
            return "//" + name.getLocalPart();
        }
        return "//*[local-name()='" + name.getLocalPart() + "' and namespace-uri()='" + name.getNamespaceURI() + "']";
    }

    private String convertElemToXpath(Element elem) {
        if ("".equals(elem.getNamespaceURI())) {
            return "//" + elem.getLocalName();
        }
        return "//*[local-name()='" + elem.getLocalName() + "' and namespace-uri()='" + elem.getNamespaceURI() + "']";
    }

    private PrivateKey getAssociatedPrivateKey(SecurableSoapMessage secureMsg) throws XWSSecurityException {
        String alias = this.keyInfoStrategy.getAlias();
        X509Certificate cert = secureMsg.getSecurityEnvironment().getCertificate(alias, true);
        if (cert == null) {
            throw new XWSSecurityException("Couldn't locate the X509 certificate corresponding to this sign operation");
        }
        this.keyInfoStrategy.setCertificate(cert);
        return secureMsg.getSecurityEnvironment().getPrivateKey(alias);
    }

    private Transforms createTransforms(SecurableSoapMessage secureMessage, boolean signTokenFlag) throws XWSSecurityException {
        Transforms transforms;
        block6: {
            transforms = new Transforms((Document)secureMessage.getSOAPPart());
            try {
                if (signTokenFlag) {
                    if (!SecurableSoapMessage.isStrTransformAdded()) {
                        try {
                            Transform.register((String)"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#STR-Transform", (String)"com.sun.xml.wss.helpers.TransformSTR");
                        }
                        catch (AlgorithmAlreadyRegisteredException e) {
                            throw new XWSSecurityException((Throwable)e);
                        }
                        SecurableSoapMessage.setStrTransformAdded((boolean)true);
                    }
                    transforms.addTransform("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#STR-Transform");
                    Transform strTransform = transforms.item(0);
                    SOAPElement strTransformElement = (SOAPElement)strTransform.getElement();
                    SOAPElement transformationParameters = strTransformElement.addChildElement("TransformationParameters", "wsse", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
                    SOAPElement canonMethod = transformationParameters.addChildElement("CanonicalizationMethod", "ds", "http://www.w3.org/2000/09/xmldsig#");
                    canonMethod.setAttribute("Algorithm", "http://www.w3.org/2001/10/xml-exc-c14n#");
                    break block6;
                }
                transforms.addTransform("http://www.w3.org/2001/10/xml-exc-c14n#");
            }
            catch (Exception e) {
                throw new XWSSecurityException(e.getMessage(), (Throwable)e);
            }
        }
        return transforms;
    }

    private Transforms createAttachmentTransforms(SecurableSoapMessage secureMessage) throws XWSSecurityException {
        Transforms transforms = new Transforms((Document)secureMessage.getSOAPPart());
        String transformURI = "http://docs.oasis-open.org/wss/2004/XX/oasis-2004XX-wss-swa-profile-1.0#Attachment-Content-Only-Transform";
        try {
            transforms.addTransform(transformURI);
        }
        catch (TransformationException e) {
            throw new XWSSecurityException((Throwable)e);
        }
        return transforms;
    }

    private void processElement(SignatureHeaderBlock sigBlock, SecurableSoapMessage secureMessage, Element element, Transforms transforms) throws XWSSecurityException {
        if (element.getNodeType() != 1) {
            FilterBase.log.log(Level.SEVERE, "WSS0165.unable.to.encrypt");
            throw new XWSSecurityException("XPath does not correspond to a DOM Element");
        }
        String id = element.getAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
        if (id.equals("")) {
            id = secureMessage.generateId();
            XMLUtil.setWsuIdAttr((Element)element, (String)id);
        }
        sigBlock.addSignedInfoReference("#" + id, transforms);
    }

    private void processAttachment(SignatureHeaderBlock sigBlock, SecurableSoapMessage secureMessage, String uri, Transforms transforms) throws XWSSecurityException {
        MimeHeaders headers = new MimeHeaders();
        headers.addHeader("Content-ID", "<" + uri.substring("cid:".length()) + ">");
        Iterator attachments = secureMessage.getAttachments(headers);
        if (!attachments.hasNext()) {
            FilterBase.log.log(Level.SEVERE, "WSS0165.unable.to.encrypt");
            throw new XWSSecurityException("No attachment with Content-ID corresponding to URI: " + uri);
        }
        sigBlock.addSignedInfoReference(uri, transforms);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

