/*
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
/*************************************************************************
   Licensed Materials - Property of IBM
   WSEE1.0 (C) Copyright International Business Machines Corp. 2002
   All Rights Reserved.
   US Government Users Restricted Rights - Use, duplication or
   disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
**************************************************************************/
/*************************************************************************
   IBM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
   ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
   PURPOSE. IN NO EVENT SHALL IBM BE LIABLE FOR ANY SPECIAL, INDIRECT OR
   CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF
   USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
   OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE
   OR PERFORMANCE OF THIS SOFTWARE.
**************************************************************************/

/*
 * $Id: Client.java 62536 2011-04-15 16:35:14Z af70133 $
 */

package com.sun.ts.tests.jaxrpc.api.javax_xml_rpc.ParameterMode;

import com.sun.ts.lib.util.*;
import com.sun.ts.lib.porting.*;
import com.sun.ts.lib.harness.*;

import java.io.*;
import java.net.*;
import java.util.*;
import java.rmi.*;

import javax.xml.rpc.*;

import com.sun.javatest.Status;

public class Client extends ServiceEETest
{
    private Properties props = null;

    public static void main(String[] args)
    {
	Client theTests = new Client();
	Status s = theTests.run(args, System.out, System.err);
	s.exit();
    }


/*  Test setup */

  /*
     * @class.testArgs:     -ap jaxrpc-url-props.dat
   *   @class.setup_props:
   */

    public void setup(String[] args, Properties p) throws Fault
    {
        logMsg("setup ok");
    }

    public void cleanup()  throws Fault {
        logMsg("cleanup ok");
    }

    /*
     *   @testName:  ToStringTest
     *
     *   @assertion_ids: JAXRPC:JAVADOC:18; JAXRPC:JAVADOC:19;
     *               JAXRPC:JAVADOC:20; JAXRPC:JAVADOC:21;
     *               WS4EE:SPEC:70
     *
     *   @test_Strategy: Verify ParameterMode.toString() method.
     */
    public void ToStringTest() throws Fault {
	TestUtil.logTrace("ToStringTest");
	boolean pass = true;
        try {
	    TestUtil.logMsg("Verify toString method");
	    TestUtil.logMsg("ParameterMode.IN.toString() = " +
			ParameterMode.IN.toString());
	    TestUtil.logMsg("ParameterMode.OUT.toString() = " +
			ParameterMode.OUT.toString());
	    TestUtil.logMsg("ParameterMode.INOUT.toString() = " +
			ParameterMode.INOUT.toString());
        } catch (Exception e) {
	    TestUtil.logErr("Caught exception: " + e.getMessage());
            TestUtil.printStackTrace(e);
	    throw new Fault("ToStringTest failed", e);
        }

	if (!pass)
	    throw new Fault("ToStringTest failed");
    }
}
