/*
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
/*************************************************************************
   Licensed Materials - Property of IBM
   WSEE1.0 (C) Copyright International Business Machines Corp. 2002
   All Rights Reserved.
   US Government Users Restricted Rights - Use, duplication or
   disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
**************************************************************************/
/*************************************************************************
   IBM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
   ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
   PURPOSE. IN NO EVENT SHALL IBM BE LIABLE FOR ANY SPECIAL, INDIRECT OR
   CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF
   USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
   OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE
   OR PERFORMANCE OF THIS SOFTWARE.
**************************************************************************/

/*
 * $Id: MarshallTestImpl.java 62536 2011-04-15 16:35:14Z af70133 $
 */

package com.sun.ts.tests.jaxrpc.ee.j2w.marshalltest;

import com.sun.ts.lib.util.*;
import com.sun.ts.lib.porting.*;
import com.sun.ts.tests.jaxrpc.common.*;

import java.io.ByteArrayInputStream;

import java.rmi.Remote;
import java.rmi.RemoteException;

import java.util.*;

import java.math.BigInteger;
import java.math.BigDecimal;

// Service Implementation Class - as outlined in JAX-RPC Specification

public class MarshallTestImpl implements MarshallTest {

    // ====================================================================
    // Java Primitive Types
    // ====================================================================
    public boolean booleanTest(boolean v) throws RemoteException {
	TestUtil.logTrace("booleanTest");
	TestUtil.logMsg("boolean="+v);
	return v;
    }

    public Boolean wrapperBooleanTest(Boolean v) throws RemoteException {
	TestUtil.logTrace("wrapperBooleanTest");
	TestUtil.logMsg("Boolean="+v);
	return v;
    }

    public byte byteTest(byte v) throws RemoteException {
	TestUtil.logTrace("byteTest");
	TestUtil.logMsg("byte="+v);
	return v;
    }

    public Byte wrapperByteTest(Byte v) throws RemoteException {
	TestUtil.logTrace("wrapperByteTest");
	TestUtil.logMsg("Byte="+v);
	return v;
    }

    public short shortTest(short v) throws RemoteException {
	TestUtil.logTrace("shortTest");
	TestUtil.logMsg("short="+v);
	return v;
    }

    public Short wrapperShortTest(Short v) throws RemoteException {
	TestUtil.logTrace("wrapperShortTest");
	TestUtil.logMsg("Short="+v);
	return v;
    }

    public int intTest(int v) throws RemoteException {
	TestUtil.logTrace("intTest");
	TestUtil.logMsg("int="+v);
	return v;
    }

    public Integer wrapperIntegerTest(Integer v) throws RemoteException {
	TestUtil.logTrace("wrapperIntegerTest");
	TestUtil.logMsg("Integer="+v);
	return v;
    }

    public long longTest(long v) throws RemoteException {
	TestUtil.logTrace("longTest");
	TestUtil.logMsg("long="+v);
	return v;
    }

    public Long wrapperLongTest(Long v) throws RemoteException {
	TestUtil.logTrace("wrapperLongTest");
	TestUtil.logMsg("Long="+v);
	return v;
    }

    public float floatTest(float v) throws RemoteException {
	TestUtil.logTrace("floatTest");
	TestUtil.logMsg("float="+v);
	return v;
    }

    public Float wrapperFloatTest(Float v) throws RemoteException {
	TestUtil.logTrace("wrapperFloatTest");
	TestUtil.logMsg("Float="+v);
	return v;
    }

    public double doubleTest(double v) throws RemoteException {
	TestUtil.logTrace("doubleTest");
	TestUtil.logMsg("double="+v);
	return v;
    }

    public Double wrapperDoubleTest(Double v) throws RemoteException {
	TestUtil.logTrace("wrapperDoubleTest");
	TestUtil.logMsg("Double="+v);
	return v;
    }

    // ====================================================================
    // Java Primitive Type Arrays (Single and Multi Dimensional)
    // ====================================================================
    public boolean[] booleanArrayTest(boolean[] v) throws RemoteException {
	TestUtil.logTrace("booleanArrayTest");
	JAXRPC_Data.dumpArrayValues(v, "boolean");
	return v;
    }

    public byte[] byteArrayTest(byte[] v) throws RemoteException {
	TestUtil.logTrace("byteArrayTest");
	JAXRPC_Data.dumpArrayValues(v, "byte");
	return v;
    }

    public short[] shortArrayTest(short[] v) throws RemoteException {
	TestUtil.logTrace("shortArrayTest");
	JAXRPC_Data.dumpArrayValues(v, "short");
	return v;
    }

    public int[] intArrayTest(int[] v) throws RemoteException {
	TestUtil.logTrace("intArrayTest");
	JAXRPC_Data.dumpArrayValues(v, "int");
	return v;
    }

    public long[] longArrayTest(long[] v) throws RemoteException {
	TestUtil.logTrace("longArrayTest");
	JAXRPC_Data.dumpArrayValues(v, "long");
	return v;
    }

    public float[] floatArrayTest(float[] v) throws RemoteException {
	TestUtil.logTrace("floatArrayTest");
	JAXRPC_Data.dumpArrayValues(v, "float");
	return v;
    }

    public double[] doubleArrayTest(double[] v) throws RemoteException {
	TestUtil.logTrace("doubleArrayTest");
	JAXRPC_Data.dumpArrayValues(v, "double");
	return v;
    }

    public boolean[][] booleanMultiArrayTest(boolean[][] v) throws RemoteException {
	TestUtil.logTrace("booleanMultiArrayTest");
	JAXRPC_Data.dumpMultiArrayValues(v, "boolean");
	return v;
    }

    public byte[][] byteMultiArrayTest(byte[][] v) throws RemoteException {
	TestUtil.logTrace("byteMultiArrayTest");
	JAXRPC_Data.dumpMultiArrayValues(v, "byte");
	return v;
    }

    public short[][] shortMultiArrayTest(short[][] v) throws RemoteException {
	TestUtil.logTrace("shortMultiArrayTest");
	JAXRPC_Data.dumpMultiArrayValues(v, "short");
	return v;
    }

    public int[][] intMultiArrayTest(int[][] v) throws RemoteException {
	TestUtil.logTrace("intMultiArrayTest");
	JAXRPC_Data.dumpMultiArrayValues(v, "int");
	return v;
    }

    public long[][] longMultiArrayTest(long[][] v) throws RemoteException {
	TestUtil.logTrace("longMultiArrayTest");
	JAXRPC_Data.dumpMultiArrayValues(v, "long");
	return v;
    }

    public float[][] floatMultiArrayTest(float[][] v) throws RemoteException {
	TestUtil.logTrace("floatMultiArrayTest");
	JAXRPC_Data.dumpMultiArrayValues(v, "float");
	return v;
    }

    public double[][] doubleMultiArrayTest(double[][] v) throws RemoteException {
	TestUtil.logTrace("doubleMultiArrayTest");
	JAXRPC_Data.dumpMultiArrayValues(v, "double");
	return v;
    }

    // ====================================================================
    // Standard Java Classes (Scalar, Single and Multi Dimensional Arrays)
    // ====================================================================
    public String stringTest(String v) throws RemoteException {
	TestUtil.logTrace("stringTest");
	TestUtil.logMsg("String="+v);
	return v;
    }

    public String[] stringArrayTest(String[] v) throws RemoteException {
	TestUtil.logTrace("stringArrayTest");
	JAXRPC_Data.dumpArrayValues(v, "String");
	return v;
    }

    public String[][] stringMultiArrayTest(String[][] v) throws RemoteException {
	TestUtil.logTrace("stringMultiArrayTest");
	JAXRPC_Data.dumpMultiArrayValues(v, "String");
	return v;
    }

    public Calendar calendarTest(Calendar v) throws RemoteException {
	TestUtil.logTrace("calendarTest");
	TestUtil.logMsg("Calendar="+v);
	return v;
    }

    public Calendar[] calendarArrayTest(Calendar[] v) throws RemoteException {
	TestUtil.logTrace("calendarArrayTest");
	JAXRPC_Data.dumpArrayValues(v, "Calendar");
	return v;
    }

    public Calendar[][] calendarMultiArrayTest(Calendar[][] v) throws RemoteException {
	TestUtil.logTrace("calendarMultiArrayTest");
	JAXRPC_Data.dumpMultiArrayValues(v, "Calendar");
	return v;
    }

    public BigInteger bigIntegerTest(BigInteger v) throws RemoteException {
	TestUtil.logTrace("bigIntegerTest");
	TestUtil.logMsg("BigInteger="+v);
	return v;
    }

    public BigInteger[] bigIntegerArrayTest(BigInteger[] v) throws RemoteException {
	TestUtil.logTrace("bigIntegerArrayTest");
	JAXRPC_Data.dumpArrayValues(v, "BigInteger");
	return v;
    }

    public BigInteger[][] bigIntegerMultiArrayTest(BigInteger[][] v) throws RemoteException {
	TestUtil.logTrace("bigIntegerMultiArrayTest");
	JAXRPC_Data.dumpMultiArrayValues(v, "BigInteger");
	return v;
    }

    public BigDecimal bigDecimalTest(BigDecimal v) throws RemoteException {
	TestUtil.logTrace("bigDecimalTest");
	TestUtil.logMsg("BigDecimal="+v);
	return v;
    }

    public BigDecimal[] bigDecimalArrayTest(BigDecimal[] v) throws RemoteException {
	TestUtil.logTrace("bigDecimalArrayTest");
	JAXRPC_Data.dumpArrayValues(v, "BigDecimal");
	return v;
    }

    public BigDecimal[][] bigDecimalMultiArrayTest(BigDecimal[][] v) throws RemoteException {
	TestUtil.logTrace("bigDecimalMultiArrayTest");
	JAXRPC_Data.dumpMultiArrayValues(v, "BigDecimal");
	return v;
    }

    // ====================================================================
    // JavaBeans Class (Scalar, Single and Multi Dimensional Arrays)
    // ====================================================================
    public JavaBean javaBeanTest(JavaBean v) throws RemoteException {
	TestUtil.logTrace("javaBeanTest");
	TestUtil.logMsg("JavaBean="+v);
	return v;
    }

    public JavaBean[] javaBeanArrayTest(JavaBean[] v) throws RemoteException {
	TestUtil.logTrace("javaBeanArrayTest");
	return v;
    }

    public JavaBean[][] javaBeanMultiArrayTest(JavaBean[][] v) throws RemoteException {
	TestUtil.logTrace("javaBeanMultiArrayTest");
	return v;
    }

    // ====================================================================
    // Value Type Class (Scalar, Single and Multi Dimensional Arrays)
    // ====================================================================
    public ValueType valueTypeTest(ValueType v) throws RemoteException {
	TestUtil.logTrace("valueTypeTest");
	TestUtil.logMsg("ValueType="+v);
	return v;
    }

    public ValueType[] valueTypeArrayTest(ValueType[] v) throws RemoteException {
	TestUtil.logTrace("valueTypeArrayTest");
	return v;
    }

    public ValueType[][] valueTypeMultiArrayTest(ValueType[][] v) throws RemoteException {
	TestUtil.logTrace("valueTypeMultiArrayTest");
	return v;
    }

    // ====================================================================
    // Service Specific Exception
    // ====================================================================
    public void myServiceExceptionTest() throws RemoteException,MyServiceException {
	TestUtil.logTrace("myServiceExceptionTest");
	throw new MyServiceException("My ServiceException");
    }

    // ====================================================================
    // The void type
    // ====================================================================
    public void voidTest() throws RemoteException {
	TestUtil.logTrace("voidTest");
    }
}
