/*
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: Client.java 62536 2011-04-15 16:35:14Z af70133 $
 */

/* Copyright (c) 2003 Oracle Corporation.  All rights reserved.  */
package com.sun.ts.tests.jaxrpc.wsi.w2j.rpc.literal.R2739;

import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jaxrpc.sharedclients.ClientFactory;
import com.sun.ts.tests.jaxrpc.wsi.constants.WSIConstants;
import com.sun.javatest.Status;

import java.util.Properties;

/**
 *  Tests R2739 in the WSI Basic Profile 1.0:
 * 	A MESSAGE MAY contain SOAP header blocks that are not described in the wsdl:binding that describes it.
 */
public class Client extends ServiceEETest implements WSIConstants{

    private W2JRLR2739Client client;

    /**
     * Test entry point.
     *
     * @param args the command-line arguments.
     */
    public static void main(String[] args) {
        Client tests = new Client();
        Status status = tests.run(args, System.out, System.err);
        status.exit();
    }

    /**
     * @class.testArgs:     -ap jaxrpc-url-props.dat
     * @class.setup_props: webServerHost;
     *                     webServerPort;
     *                     platform.mode;
     *
     * @param args
     * @param properties
     *
     * @throws com.sun.ts.lib.harness.EETest.Fault
     */
    public void setup(String[] args, Properties properties) throws EETest.Fault {
        client = (W2JRLR2739Client)ClientFactory.getClient(W2JRLR2739Client.class, properties);
        logMsg("setup ok");
    }

    public void cleanup(){
        logMsg("cleanup");
    }

    /**
     * @testName: testExtraHeader
     *
     * @assertion_ids: JAXRPC:WSI:R2739
     *
     * @test_Strategy: Make a request and add a header not contained
     * in the wsdl. Ensure the request and response are normal.
     *
     * @throws com.sun.ts.lib.harness.EETest.Fault
     */
    public void testExtraHeader() throws EETest.Fault {
        String response = "";
        try{
            response = client.helloWorld();
        }catch(Exception e){
            TestUtil.printStackTrace(e);
            throw new EETest.Fault("Test didn't complete properly: ", e);
        }
        if(!response.equals("hello world")){
            throw new EETest.Fault("Error creating response object:" + response);
        }
    }
}
