/*
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: Client.java 62536 2011-04-15 16:35:14Z af70133 $
 */

/* Copyright (c) 2003 Oracle Corporation.  All rights reserved.  */
package com.sun.ts.tests.jaxrpc.wsi.w2j.rpc.literal.R2744;

import java.util.Properties;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.tests.jaxrpc.sharedclients.ClientFactory;

/**
 * Tests R2744 in the WSI Basic Profile 1.0:
 * A MESSAGE MUST contain a SOAPAction HTTP header field with a quoted value equal
 * to the value of the soapAction attribute of soapbind:operation, if present in
 * the corresponding WSDL description.
 */
public class Client extends ServiceEETest {
    /**
     * The one string to be echoed.
     */
    private static final String STRING = "R2744";

    /**
     * The one client.
     */
    private W2JRLR2744Client client;
    
    /**
     * Test entry point.
     * 
     * @param args the command-line arguments.
     */
    public static void main(String[] args) {
        Client client = new Client();
        Status status = client.run(args, System.out, System.err);
        status.exit();
    }
    
    /**
     * @class.testArgs:     -ap jaxrpc-url-props.dat
     * @class.setup_props: webServerHost;
     *                     webServerPort;
     *                     platform.mode;
     *
     * @param args
     * @param properties
     *
     * @throws Fault
     */
    public void setup(String[] args, Properties properties) throws Fault {
        client = (W2JRLR2744Client)ClientFactory.getClient(W2JRLR2744Client.class, properties);
        logMsg("setup ok");
    }

    public void cleanup() {
        logMsg("cleanup");
    }

    /**
     * @testName: testSOAPAction
     *
     * @assertion_ids: JAXRPC:WSI:R2744
     *
     * @test_Strategy: The supplied WSDL, containing a soap:operation with a soapAction
     * attribute, has been used by the WSDL-to-Java tool to generate
     * an endpoint and client. The endpoint has been replaced by a Servlet Filter that
     * verifies the presence of the SOAPAction header and its quoted value.
     *
     * @throws Fault
     */
    public void testSOAPAction() throws Fault {
        String result;
        try {
            result = client.echoString(STRING);
            System.out.println("result="+result);
        } catch (Exception e) {
            throw new Fault("Unable to invoke echoString operation (BP-R2744)", e);
        }
        if (!result.equals("OK")) {
            throw new Fault("Missing or invalid SOAPAction header (BP-R2744)");
        }
    }
}
