/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.HtmlInput;
import java.io.IOException;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlCheckBoxInput
extends HtmlInput {
    private static final long serialVersionUID = 3567976425357413976L;
    private boolean defaultCheckedState_ = this.isAttributeDefined("checked");

    HtmlCheckBoxInput(String namespaceURI, String qualifiedName, SgmlPage page, Map<String, DomAttr> attributes) {
        super(namespaceURI, qualifiedName, page, attributes);
        if (this.getAttributeValue("value") == ATTRIBUTE_NOT_DEFINED) {
            this.setAttributeValue("value", "on");
        }
    }

    @Override
    public void reset() {
        this.setChecked(this.defaultCheckedState_);
    }

    @Override
    public Page setChecked(boolean isChecked) {
        if (isChecked) {
            this.setAttributeValue("checked", "checked");
        } else {
            this.removeAttribute("checked");
        }
        return HtmlCheckBoxInput.executeOnChangeHandlerIfAppropriate(this);
    }

    @Override
    public String asText() {
        if (this.isChecked()) {
            return "checked";
        }
        return "unchecked";
    }

    @Override
    protected Page doClickAction(Page defaultPage) throws IOException {
        this.setChecked(!this.isChecked());
        return super.doClickAction(defaultPage);
    }

    @Override
    protected boolean isStateUpdateFirst() {
        return true;
    }

    @Override
    protected void preventDefault() {
        this.setChecked(!this.isChecked());
    }

    @Override
    public void setDefaultValue(String defaultValue) {
        super.setDefaultValue(defaultValue);
        this.setValueAttribute(defaultValue);
    }

    @Override
    public void setDefaultChecked(boolean defaultChecked) {
        this.defaultCheckedState_ = defaultChecked;
        if (this.getPage().getWebClient().getBrowserVersion().isNetscape()) {
            this.setChecked(defaultChecked);
        }
    }

    @Override
    public boolean isDefaultChecked() {
        return this.defaultCheckedState_;
    }
}

