/*
 * Copyright (c) 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id$ 
 */
package com.sun.ts.tests.jaxrs.api.client.clientresponsecontext;

import javax.ws.rs.ext.RuntimeDelegate;

import com.sun.ts.tests.jaxrs.common.provider.StringBean;
import com.sun.ts.tests.jaxrs.common.provider.StringBeanRuntimeDelegate;

/**
 * Runtime Delegate for getHeaderStringIsEmptyTest
 */
public class NullStringBeanRuntimeDelegate extends StringBeanRuntimeDelegate {

	public NullStringBeanRuntimeDelegate(RuntimeDelegate orig) {
		super(orig);
	}
	
	@SuppressWarnings("unchecked")
	@Override
	public <T> HeaderDelegate<T> createHeaderDelegate(Class<T> arg0)
			throws IllegalArgumentException {
		if (arg0 == StringBean.class)			
			return (HeaderDelegate<T>) new NullStringBeanHeaderDelegate();
		else
			return super.createHeaderDelegate(arg0);
	}	

}
