/*
 * Copyright (c) 2012, 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 * $Id: JAXRSClient.java 69965 2013-02-13 12:02:10Z supol $
 */
package com.sun.ts.tests.jaxrs.api.rs.bindingpriority;

import java.util.concurrent.atomic.AtomicInteger;

import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Response.Status;

import com.sun.ts.tests.jaxrs.common.JAXRSCommonClient;

/*
 * @class.setup_props: webServerHost;
 *                     webServerPort;
 *                     ts_home;
 */
public class JAXRSClient extends JAXRSCommonClient {

	private static final long serialVersionUID = 1501029701397272718L;

	/**
	 * Entry point for different-VM execution.  It should delegate to method
	 * run(String[], PrintWriter, PrintWriter), and this method should not
	 * contain any test configuration.
	 */
	public static void main(String[] args) {
		new JAXRSClient().run(args);
	}

	/* Run test */

	/*
	 * @testName: checkBindingPriorityHigherRegisteredFirstTest
	 * @assertion_ids: JAXRS:SPEC:92;
	 * @test_Strategy: Priority defined for a filter or interceptor.
	 */
	public void checkBindingPriorityHigherRegisteredFirstTest() throws Fault {
		AtomicInteger ai = new AtomicInteger(0);
		ContextProvider lowerProiority = new LowerPriorityProvider(ai);
		ContextProvider higherPriority = new HigherPriorityProvider(ai);
		Response response = invokeWithClientRequestFilters(higherPriority,
				lowerProiority);
		assertFault(response.getStatus() == Status.OK.getStatusCode(),
				"returned status", response.getStatus());
	}

	/*
	 * @testName: checkBindingPriorityLowerRegisteredFirstTest
	 * @assertion_ids: JAXRS:SPEC:92;
	 * @test_Strategy: Priority defined for a filter or interceptor.
	 */
	public void checkBindingPriorityLowerRegisteredFirstTest() throws Fault {
		AtomicInteger ai = new AtomicInteger(0);
		ContextProvider lowerProiority = new LowerPriorityProvider(ai);
		ContextProvider higherPriority = new HigherPriorityProvider(ai);
		Response response = invokeWithClientRequestFilters(lowerProiority,
				higherPriority);
		assertFault(response.getStatus() == Status.OK.getStatusCode(),
				"returned status", response.getStatus());
	}

	//////////////////////////////////////////////////////////////////////
	
	protected Response invokeWithClientRequestFilters(
			ClientRequestFilter... filters) {
		Client client = ClientBuilder.newClient();
		for (ClientRequestFilter filter : filters)
			client.register(filter);
		WebTarget target = client.target("http://nourl/");
		Response response = target.request().buildGet().invoke();
		return response;
	}

}
