/*
 * Copyright (c) 2012, 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id$ 
 */

package com.sun.ts.tests.jaxrs.api.rs.core.configurable;

import javax.ws.rs.client.Client;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Configurable;

import com.sun.ts.lib.harness.EETest.Fault;

public abstract class SingleCheckAssertable extends Assertable {

	protected abstract void check(Configurable<?> configurable) throws Fault;
	
	@Override
	public void check1OnClient(Client client) throws Fault {
		check(client);
	}

	@Override
	public void check2OnTarget(WebTarget target) throws Fault {
		check(target);
	}

}
