/*
 * Copyright (c) 2017, 2018 Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: JaxbKeyValueBean.java 75638 2018-05-07 13:07:39Z jsupol $ 
 */
package com.sun.ts.tests.jaxrs.common.impl;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
@XmlAccessorType(XmlAccessType.FIELD)
public class JaxbKeyValueBean {
	@XmlElement
	public String key;
	@XmlElement
	public String value;

	public String getKey() {
		return key;
	}

	public void setKey(String key) {
		this.key = key;
	}

	public String getValue() {
		return value;
	}

	public void setValue(String value) {
		this.value = value;
	}

	public JaxbKeyValueBean set(String key, String value) {
		setKey(key);
		setValue(value);
		return this;
	}
}
