/*
 * Copyright (c) 2012, 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: StringBeanHeaderDelegate.java 69965 2013-02-13 12:02:10Z supol $ 
 */

package com.sun.ts.tests.jaxrs.common.provider;

import javax.ws.rs.ext.Provider;
import javax.ws.rs.ext.RuntimeDelegate.HeaderDelegate;

@Provider
public class StringBeanHeaderDelegate implements HeaderDelegate<StringBean> {

	@Override
	public StringBean fromString(String string) throws IllegalArgumentException {
		return new StringBean(string);
	}

	@Override
	public String toString(StringBean bean) throws IllegalArgumentException {
		return bean.get();
	}

}
