/*
 * Copyright (c) 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 * $Id$
 */
package com.sun.ts.tests.jaxrs.ee.resource.java2entity;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collection;

import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;

import com.sun.ts.tests.jaxrs.common.AbstractMessageBodyRW;

/**
 * Complement to CollectionWriter, writes error 
 */
@Provider
public class IncorrectCollectionWriter extends AbstractMessageBodyRW
		implements MessageBodyWriter<Collection<?>> {

	public static final String ERROR = "ERROR ";

	@Override
	public boolean isWriteable(Class<?> type, Type genericType,
			Annotation[] annotations, MediaType mediaType) {
		return !new CollectionWriter().isWriteable(type, genericType,
				annotations, mediaType);
	}

	@Override
	public long getSize(Collection<?> t, Class<?> type, Type genericType,
			Annotation[] annotations, MediaType mediaType) {
		String path = getPathValue(annotations);
		return ERROR.length() + path.length();
	}

	@Override
	public void writeTo(Collection<?> t, Class<?> type, Type genericType,
			Annotation[] annotations, MediaType mediaType,
			MultivaluedMap<String, Object> httpHeaders,
			OutputStream entityStream) throws IOException,
			WebApplicationException {
		String path = getPathValue(annotations);
		entityStream.write(ERROR.getBytes());
		entityStream.write(path.getBytes());
	}
}
