/*
 * Copyright (c) 2014, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: QueryBeanParamEntity.java 74172 2014-10-30 14:11:06Z supol $ 
 */

package com.sun.ts.tests.jaxrs.ee.rs.beanparam.query.bean;

import java.util.List;
import java.util.Set;
import java.util.SortedSet;

import javax.ws.rs.BeanParam;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.Encoded;
import javax.ws.rs.QueryParam;

import com.sun.ts.tests.jaxrs.ee.rs.Constants;
import com.sun.ts.tests.jaxrs.ee.rs.ParamEntityThrowingExceptionGivenByName;
import com.sun.ts.tests.jaxrs.ee.rs.ParamEntityThrowingWebApplicationException;
import com.sun.ts.tests.jaxrs.ee.rs.ParamEntityWithConstructor;
import com.sun.ts.tests.jaxrs.ee.rs.ParamEntityWithFromString;
import com.sun.ts.tests.jaxrs.ee.rs.ParamEntityWithValueOf;

public class QueryBeanParamEntity {
	@DefaultValue(Constants.DEFAULT_VALUE)
	@QueryParam(Constants.PARAM_ENTITY_WITH_CONSTRUCTOR)
	public ParamEntityWithConstructor paramEntityWithConstructor;

	@Encoded
	@DefaultValue(Constants.DEFAULT_VALUE)
	@QueryParam(Constants.PARAM_ENTITY_WITH_FROMSTRING)
	public ParamEntityWithFromString paramEntityWithFromString;

	@DefaultValue(Constants.DEFAULT_VALUE)
	@QueryParam(Constants.PARAM_ENTITY_WITH_VALUEOF)
	public ParamEntityWithValueOf paramEntityWithValueOf;

	@DefaultValue(Constants.DEFAULT_VALUE)
	@QueryParam(Constants.SET_PARAM_ENTITY_WITH_FROMSTRING)
	public Set<ParamEntityWithFromString> setParamEntityWithFromString;

	@DefaultValue(Constants.DEFAULT_VALUE)
	@QueryParam(Constants.SORTED_SET_PARAM_ENTITY_WITH_FROMSTRING)
	public SortedSet<ParamEntityWithFromString> sortedSetParamEntityWithFromString;

	@DefaultValue(Constants.DEFAULT_VALUE)
	@QueryParam(Constants.LIST_PARAM_ENTITY_WITH_FROMSTRING)
	public List<ParamEntityWithFromString> listParamEntityWithFromString;

	@QueryParam(Constants.ENTITY_THROWING_WEBAPPLICATIONEXCEPTION)
	public ParamEntityThrowingWebApplicationException entityThrowingWebApplicationException;
	
	@QueryParam(Constants.ENTITY_THROWING_EXCEPTION_BY_NAME)
	public ParamEntityThrowingExceptionGivenByName entityThrowingExceptionGivenByName;
	
	@BeanParam
	public InnerQueryBeanParamEntity inner;
}
