/*
 * Copyright (c) 2007, 2014, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: ApplicationServlet.java 73552 2014-02-27 20:34:24Z supol $
 */

package com.sun.ts.tests.jaxrs.ee.rs.core.application;

import java.util.Map;
import java.util.Set;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

import com.sun.ts.tests.jaxrs.common.util.JaxrsUtil;

@Path("ApplicationTest")
public class ApplicationServlet {

	@GET
	@Path("/GetSingletons")
	public Response testGetSingletons(@Context Application application) {
		// Derived from the default, thus return empty implementation
		if (application.getSingletons() == null)
			return Response.status(Response.Status.NOT_ACCEPTABLE).build();
		// Passed
		return Response.ok(String.valueOf(application.getSingletons().size()))
				.build();
	}

	@GET
	@Path("/GetClasses")
	public Response testGetClasses(@Context Application application) {
		// Context Issue
		application = getDeproxiedApplication(application);
		if (!application.getClasses().contains(ApplicationServlet.class))
			return Response.status(Response.Status.NOT_ACCEPTABLE).build();
		// Passed
		return Response.ok(String.valueOf(application.getClasses().size()))
				.build();
	}

	@Path("properties")
	@GET
	public Response getProperties(@Context Application application) {
		Response response = null;
		application = getDeproxiedApplication(application);
		Map<String, Object> properties = application.getProperties();
		if (properties == null || properties.size() == 0) {
			response = Response.noContent().build();
		} else {
			Object val0 = properties.get(TSAppConfig.KEYS[0]);
			Object val1 = properties.get(TSAppConfig.KEYS[1]);
			if (TSAppConfig.VALUES[0].equals(val0)
					&& TSAppConfig.VALUES[1].equals(val1))
				response = Response.ok(JaxrsUtil.mapToString(properties))
						.build();
			else
				response = Response.status(Response.Status.NOT_ACCEPTABLE)
						.build();
		}
		return response;
	}

	// ////////////////////////////////////////////////////////////////////////

	/**
	 * Deproxy
	 */
	protected static Application getDeproxiedApplication(Application application) {
		Set<Object> singletons = application.getSingletons();
		for (Object s : singletons)
			if (s.getClass() == ApplicationHolderSingleton.class)
				return ((ApplicationHolderSingleton) s).getApplication();
		throw new IllegalStateException(
				"ApplicationHolderSingleton has not been found in a list of singletons");
	}

}
