/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: ProceedException.java 70988 2013-03-22 15:55:49Z supol $ 
 */

package com.sun.ts.tests.jaxrs.ee.rs.ext.interceptor.writer.writerinterceptorcontext;

import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;

import com.sun.ts.tests.jaxrs.api.rs.ext.interceptor.TemplateInterceptorBody;

public class ProceedException extends WebApplicationException {

	private static final long serialVersionUID = -8012949565468746147L;
	
	private String msg; 

	public ProceedException(String msg) {
		super(Response
				.ok(msg)
				.header(TemplateInterceptorBody.OPERATION,
						ContextOperation.FROMPROCEEDTHROWSWEBAPPEXCEPTION.name())
				.build());
		this.msg = msg;
	}

	/**
	 * Acyclic getCause() returns equivalent of this
	 */
	@Override
	public Throwable getCause() {
		return new ProceedException(msg){
			private static final long serialVersionUID = 256996856963444570L;

			@Override
			public Throwable getCause() {			
				return null;
			}
		};
	}
	
	@Override
	public String getMessage() {	
		return msg;
	}
}
