/*
 * Copyright (c) 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id$
 */

package com.sun.ts.tests.jaxrs.ee.rs.ext.paramconverter;

import java.util.concurrent.atomic.AtomicInteger;

import javax.ws.rs.ext.ParamConverter;
import javax.ws.rs.ext.ParamConverter.Lazy;

@Lazy
public class AtomicIntegerLazyParamConverter implements ParamConverter<AtomicInteger> {

	@Override
	public AtomicInteger fromString(String value)
			throws IllegalArgumentException {	
		return new AtomicInteger(Integer.parseInt(value));
	}

	@Override
	public String toString(AtomicInteger value) throws IllegalArgumentException {
		return String.valueOf(value.get());
	}

}
