/*
 * Copyright (c) 2012, 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: JAXRSLocatorClient.java 71955 2013-05-22 18:30:50Z supol $
 */

package com.sun.ts.tests.jaxrs.ee.rs.formparam.locator;

import com.sun.ts.tests.jaxrs.ee.rs.formparam.JAXRSClient;

/*
 * @class.setup_props: webServerHost;
 *                     webServerPort;
 *                     ts_home;
 */
public class JAXRSLocatorClient extends JAXRSClient {

	public JAXRSLocatorClient() {
		setContextRoot("/jaxrs_ee_formparam_locator_web/resource/locator");
	}

	private static final long serialVersionUID = 1L;

	/**
	 * Entry point for different-VM execution.  It should delegate to method
	 * run(String[], PrintWriter, PrintWriter), and this method should not
	 * contain any test configuration.
	 */
	public static void main(String[] args) {
		JAXRSLocatorClient theTests = new JAXRSLocatorClient();
		theTests.run(args);
	}

	/*
	 * @testName: nonDefaultFormParamNothingSentTest
	 * @assertion_ids: JAXRS:JAVADOC:4; 
	 * 				 	JAXRS:SPEC:12; 
	 * 					JAXRS:SPEC:20; JAXRS:SPEC:20.3;
	 * @test_Strategy: Test sending no content;
	 */
	public void nonDefaultFormParamNothingSentTest() throws Fault {
		super.nonDefaultFormParamNothingSentTest();
	}

	/*
	 * @testName: nonDefaultFormParamValueOfTest
	 * @assertion_ids: JAXRS:JAVADOC:4;
	 * 				 	JAXRS:SPEC:12; 
	 * 					JAXRS:SPEC:20; JAXRS:SPEC:20.3;
	 * @test_Strategy: Test creating a ParamEntityWithValueOf from sending 
	 * 				   a String;
	 */
	public void nonDefaultFormParamValueOfTest() throws Fault {
		super.nonDefaultFormParamValueOfTest();
	}

	/*
	 * @testName: nonDefaultFormParamFromStringTest
	 * @assertion_ids: JAXRS:JAVADOC:4;
	 * 				 	JAXRS:SPEC:12; 
	 * 					JAXRS:SPEC:20; JAXRS:SPEC:20.3;
	 * @test_Strategy: Test creating a ParamEntityWithFromString from sending 
	 * 				   a String;
	 */
	public void nonDefaultFormParamFromStringTest() throws Fault {
		_contextRoot += "encoded";
		super.nonDefaultFormParamFromStringTest();
	}

	/*
	 * @testName: nonDefaultFormParamFromConstructorTest
	 * @assertion_ids: JAXRS:JAVADOC:4;
	 * 				 	JAXRS:SPEC:12; 
	 * 					JAXRS:SPEC:20; JAXRS:SPEC:20.3;
	 * @test_Strategy: Test creating a ParamEntityWithConstructor from sending 
	 * 				   a String;
	 */
	public void nonDefaultFormParamFromConstructorTest() throws Fault {
		super.nonDefaultFormParamFromConstructorTest();
	}

	/*
	 * @testName: nonDefaultFormParamFromListConstructorTest
	 * @assertion_ids: JAXRS:JAVADOC:4;
	 * 				 	JAXRS:SPEC:12; 
	 * 					JAXRS:SPEC:20; JAXRS:SPEC:20.3;
	 * @test_Strategy: Test creating a ParamEntityWithConstructor from 
	 * 				   sending a String;
	 */
	public void nonDefaultFormParamFromListConstructorTest() throws Fault {
		super.nonDefaultFormParamFromListConstructorTest();
	}

	/*
	 * @testName: nonDefaultFormParamFromSetFromStringTest
	 * @assertion_ids: JAXRS:JAVADOC:4;
	 * 				 	JAXRS:SPEC:12; 
	 * 					JAXRS:SPEC:20; JAXRS:SPEC:20.3;
	 * @test_Strategy: Test creating a ParamEntityWithListConstructor from 
	 * 				   sending a String;
	 */
	public void nonDefaultFormParamFromSetFromStringTest() throws Fault {
		_contextRoot += "encoded";
		super.nonDefaultFormParamFromSetFromStringTest();
	}

	/*
	 * @testName: nonDefaultFormParamFromSortedSetFromStringTest
	 * @assertion_ids: JAXRS:JAVADOC:4;
	 * 				 	JAXRS:SPEC:12; 
	 * 					JAXRS:SPEC:20; JAXRS:SPEC:20.3;
	 * @test_Strategy: Test creating a ParamEntityWithListConstructor from 
	 * 				   sending a String;
	 */
	public void nonDefaultFormParamFromSortedSetFromStringTest() throws Fault {
		_contextRoot += "encoded";
		super.nonDefaultFormParamFromSortedSetFromStringTest();
	}

	/*
	 * @testName: nonDefaultFormParamFromListFromStringTest
	 * @assertion_ids: JAXRS:JAVADOC:4;
	 * 				 	JAXRS:SPEC:12; 
	 * 					JAXRS:SPEC:20; JAXRS:SPEC:20.3;
	 * @test_Strategy: Test creating a ParamEntityWithListConstructor from 
	 * 				   sending a String;
	 */
	public void nonDefaultFormParamFromListFromStringTest() throws Fault {
		_contextRoot += "encoded";
		super.nonDefaultFormParamFromListFromStringTest();
	}

	/* 
	 * @assertion_ids: JAXRS:SPEC:7; 	 
	 * 				 	JAXRS:SPEC:12;JAXRS:SPEC:12.2;
	 * 					JAXRS:SPEC:20; JAXRS:SPEC:20.3;
	 * @test_Strategy: Verify that named FormParam @Encoded is handled
	 */ 	 
	public void formParamEntityWithEncodedTest() throws Fault {
		_contextRoot += "encoded";
		super.paramEntityWithEncodedTest();
	}

}