/*
 * Copyright (c) 2017, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id$ 
 */

package com.sun.ts.tests.jaxrs.jaxrs21.spec.completionstage;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executors;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.WebApplicationException;

@Path("/async")
public class CompletionStageResource {

	public static final String MESSAGE = CompletionStageResource.class.getName();

	@GET
	public CompletionStage<String> async() {
		CompletableFuture<String> cs = new CompletableFuture<>();
		Executors.newSingleThreadExecutor().submit(() -> {
			try {
				Thread.sleep(1000L);
			} catch (InterruptedException e) {
				throw new WebApplicationException(e);
			}
			cs.complete(MESSAGE);
		});
		return cs;
	}
}
