/*
 * Copyright (c) 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id$  
 */

package com.sun.ts.tests.jaxrs.spec.client.invocations;

import java.util.List;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;

@Path("resource")
public class Resource {

	@GET
	@Path("call")
	public String invoke() {
		return Resource.class.getName();
	}

	@GET
	@Path("mediatype")
	public String media(@Context HttpHeaders headers) {
		List<MediaType> accept = headers.getAcceptableMediaTypes();
		return acceptableMediaTypesToString(accept).toString();
	}

	private static StringBuilder acceptableMediaTypesToString(List<MediaType> list) {
		StringBuilder sb = new StringBuilder();
		for (MediaType type : list)
			sb.append(type.toString());
		return sb;
	}
}
