/*
 * Copyright (c) 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id$ 
 */

package com.sun.ts.tests.jaxrs.spec.client.resource;

import com.sun.ts.tests.jaxrs.common.client.JaxrsCommonClient;

/*
 * @class.setup_props: webServerHost;
 *                     webServerPort;
 *                     ts_home;
 */
public class JAXRSClient extends JaxrsCommonClient {

	private static final long serialVersionUID = 1339633069677106930L;
	
    public JAXRSClient() {
        setContextRoot("/jaxrs_spec_client_resource_web/resource");
    }	

	public static void main(String[] args) {
		new JAXRSClient().run(args);
	}

	/* Run test */
	/*
	 * @testName: checkClientConceptTest
	 * @assertion_ids: JAXRS:SPEC:65;
	 * @test_Strategy: Conceptually, the steps required to submit a request 
	 * 					are the following: 
	 * 					(i) obtain an instance of Client 
	 * 					(ii) create a WebTarget 
	 * 					(iii) create a request from the WebTarget and 
	 * 					(iv) submit a request or get a prepared Invocation 
	 * 						for later submission
	 */
	public void checkClientConceptTest() throws Fault {
		setProperty(Property.REQUEST, buildRequest(Request.GET, "concept"));
		setProperty(Property.SEARCH_STRING, "concept");
		invoke();
	}
}
