/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: NeverUsedExceptionMapper.java 69692 2013-01-30 14:23:20Z supol $  
 */

package com.sun.ts.tests.jaxrs.spec.filter.exception;

import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;

/**
 * This exception mapper shall never be used. If used, than the Spec. is not
 * followed for various set of reasons such as 1)RuntimeExceptionMapper should
 * be used first 2) RuntimeExceptionMapper has once been used and after
 * consequent exception no Exception mapper should be used, as defined in
 * Section 6.7 of the Spec. 3) Checked Exception (e.g. IOException) has been
 * unexpectedly thrown
 */
@Provider
public class NeverUsedExceptionMapper implements ExceptionMapper<Exception> {

	@Override
	public Response toResponse(Exception exception) {
		return Response.ok(Integer.MIN_VALUE).build();
	}

}
