/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: SecondReaderInterceptor.java 69965 2013-02-13 12:02:10Z supol $  
 */

package com.sun.ts.tests.jaxrs.spec.filter.lastvalue;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;

import javax.annotation.Priority;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.ReaderInterceptor;
import javax.ws.rs.ext.ReaderInterceptorContext;

import com.sun.ts.tests.jaxrs.spec.filter.interceptor.Resource;

@Priority(200)
public class SecondReaderInterceptor implements ReaderInterceptor {

	@Override
	public Object aroundReadFrom(ReaderInterceptorContext context)
			throws IOException, WebApplicationException {
		MultivaluedMap<String, String> headers = context.getHeaders();
		String header = headers.getFirst(Resource.HEADERNAME);
		if (header != null
				&& header.equals(FirstReaderInterceptor.class.getName())) {
			context.setAnnotations(getClass().getAnnotations());
			context.setInputStream(new ByteArrayInputStream(getClass()
					.getName().getBytes()));
			context.setMediaType(MediaType.TEXT_PLAIN_TYPE);
			context.setType(ArrayList.class);
		}
		return context.proceed();
	}
}
