/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: SecondWriterInterceptor.java 69965 2013-02-13 12:02:10Z supol $  
 */

package com.sun.ts.tests.jaxrs.spec.filter.lastvalue;

import java.io.IOException;
import java.util.ArrayList;

import javax.annotation.Priority;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.WriterInterceptor;
import javax.ws.rs.ext.WriterInterceptorContext;

import com.sun.ts.tests.jaxrs.spec.filter.interceptor.Resource;

@Priority(200)
public class SecondWriterInterceptor implements WriterInterceptor {

	@Override
	public void aroundWriteTo(WriterInterceptorContext context)
			throws IOException, WebApplicationException {
		MultivaluedMap<String, Object> headers = context.getHeaders();
		String header = (String) headers.getFirst(Resource.HEADERNAME);
		if (header != null
				&& header.equals(FirstWriterInterceptor.class.getName())) {
			context.setAnnotations(getClass().getAnnotations());
			context.setEntity(toList(getClass().getName()));
			context.setGenericType(String.class);
			context.setMediaType(MediaType.TEXT_PLAIN_TYPE);
			context.setType(ArrayList.class);
		}
		context.proceed();
	}
	
	private static <T> ArrayList<T> toList(T o){
		ArrayList<T> list = new ArrayList<T>();
		list.add(o);
		return list;
	}

}
