/*
 * Copyright (c) 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id$  
 */

package com.sun.ts.tests.jaxrs.spec.provider.reader;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;

import javax.ws.rs.Consumes;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.Provider;

@Provider
@Consumes("application/java")
public class AppJavaReader extends AbstractReader {
	// Do not inherit
	private static boolean isReadable = false;

	public static void setWritable(boolean bool) {
		isReadable = bool;
	}

	@Override
	public boolean isReadable(Class<?> type, Type genericType,
			Annotation[] annotations, MediaType mediaType) {
		AbstractReader.readerSet.append(getClass().getSimpleName());
		return isReadable;
	}

}
