/*
 * Copyright (c) 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 * $Id$
 */

package com.sun.ts.tests.jaxrs.spec.resource.requestmatching;

import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;

@Path("resource/subresource/sub")
public class AnotherSubResource {

	@POST
	@Consumes(MediaType.TEXT_PLAIN)
	public String sub() {
		return getClass().getSimpleName();
	}

	@POST	
	public String subsub() {
		return sub() + sub();
	}

	@GET
	public String get() {
		return sub();
	}

	@GET
	@Produces(MediaType.TEXT_PLAIN)
	public String getget() {
		return subsub();
	}

	@GET
	@Produces("text/*")
	public String getTextStar() {
		return "text/*";
	}

	@POST
	@Consumes("text/*")
	public String postTextStar() {
		return "text/*";
	}		
}
