/*
 * Copyright (c) 2007, 2009, Oracle and its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: MTOMFeatureTestImpl3.java 62602 2011-04-21 14:51:41Z kgrucci $
 */

package com.sun.ts.tests.jaxws.ee.w2j.document.literal.mtomfeature;

import com.sun.ts.lib.util.*;
import com.sun.ts.lib.porting.*;
import com.sun.ts.lib.harness.*;

import javax.jws.WebService;
import javax.xml.ws.BindingType;
import javax.xml.ws.Holder;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.soap.SOAPBinding;
import javax.xml.ws.soap.MTOM;

import java.awt.Image;
import com.sun.ts.tests.jaxws.common.AttachmentHelper;
import java.net.URL;
import javax.activation.DataHandler;
import javax.xml.transform.Source;

@WebService(
    portName="MTOMFeatureTest3Port",
    serviceName="MTOMFeatureTestService",
    targetNamespace="http://mtomfeatureservice.org/wsdl",
    wsdlLocation="WEB-INF/wsdl/MTOMFeatureTestService.wsdl",
    endpointInterface="com.sun.ts.tests.jaxws.ee.w2j.document.literal.mtomfeature.MTOMFeatureTest3"
)
@BindingType(value=SOAPBinding.SOAP11HTTP_BINDING)
@MTOM(enabled=true, threshold=2000)

public class MTOMFeatureTestImpl3 implements MTOMFeatureTest3 {

    public com.sun.ts.tests.jaxws.ee.w2j.document.literal.mtomfeature.DataType33 threshold2000(com.sun.ts.tests.jaxws.ee.w2j.document.literal.mtomfeature.DataType3 data) {

      System.out.println("--------------------------");
      System.out.println("In MTOMFeatureTestImpl3:threshold2000");

      DataType33 data33 = new DataType33();
      data33.setTestName(data.getTestName());
      data33.setDoc(data.getDoc());
      
      return data33;
    }
}
