/*
 * Copyright (c) 2009, 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.sun.ts.tests.jpa.core.annotations.convert;

import javax.persistence.*;

@Embeddable
@Access(AccessType.PROPERTY)
public class Address implements java.io.Serializable{

    protected String street;
    protected String city;
    protected int state;

    
    public Address(){
    }

    public Address(String street, String city, int state) {
        this.street = street;
        this.city = city;
        this.state = state;
    }

    public String getCity() {
        return city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public int getState() {
        return state;
    }

    public void setState(int state) {
        this.state = state;
    }

    public String getStreet() {
        return street;
    }

    public void setStreet(String street) {
        this.street = street;
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getSimpleName()+"[");
        result.append("street: " + getStreet());
        result.append(", city: " + getCity());
        result.append(", state: " + getState());
        result.append("]");
        return result.toString();
    }

}

