/*
 * Copyright (c) 2014, 2018, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

 
package com.sun.ts.tests.jpa.core.annotations.mapkeyenumerated;

import javax.persistence.*;
import java.util.Map;

@Entity
@Table(name="DEPARTMENT2")
public class Department4 implements java.io.Serializable {

	private static final long serialVersionUID = 22L;
	// Instance variables
    @Id 
    private int  id;
    private String  name;
    @Transient
    private Map<Numbers, EmbeddedEmployee> lastNameEmployees;

    public Department4() {
    }

    public Department4(int id, String name) {
        this.id = id;
        this.name = name;
    }


    // ===========================================================
    // getters and setters for the state fields

    @Column(name="ID")
    public int getId() {
        return id;
    }
    public void setId(int id) {
        this.id = id;
    }

    @Column(name="NAME")
    public String getName() {
        return name;
    }
    public void setName(String name) {
        this.name = name;
    }

    // ===========================================================
    // getters and setters for the association fields

    @ElementCollection(targetClass=EmbeddedEmployee.class)
    @CollectionTable(
            name="EMP_MAPKEYCOL2",
            joinColumns=@JoinColumn(name="FK_DEPT5")   
    )
    @AttributeOverrides({	
        @AttributeOverride(name="employeeId", 
                column=@Column(name="ID")),
        @AttributeOverride(name="employeeName", 
                column=@Column(name="LASTNAME"))        
    })
    @MapKeyEnumerated(EnumType.STRING)
    public Map<Numbers, EmbeddedEmployee> getLastNameEmployees() {
        return lastNameEmployees;
    }

    public void setLastNameEmployees(Map<Numbers, EmbeddedEmployee> lastNameEmployees) {
        this.lastNameEmployees = lastNameEmployees;
    }
    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getSimpleName() + "[");
        result.append("id: " + getId());
        if (getName() != null) {
            result.append(", name: " + getName());
        } else {
            result.append(", name: null");
        }
        result.append("]");
        return result.toString();
    }
}
