/*
 * Copyright (c) 2007, 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
 
/*
 * $Id: Insurance.java 65615 2012-03-29 19:02:39Z sdimilla $
 */

package com.sun.ts.tests.jpa.core.annotations.orderby;


 import javax.persistence.*;
 import java.util.List;

/*
 * Insurance
 */

@Entity
public class Insurance implements java.io.Serializable {

    // Instance variables
    private int  id;
    private String  carrier;
    private List<Employee> employees;

    public Insurance() {
    }

    public Insurance(int id, String carrier) {
        this.id = id;
        this.carrier = carrier;
    }


    // ===========================================================
    // getters and setters for the state fields

    @Id
    @Column(name="INSID")
    public int getId() {
        return id;
    }
    public void setId(int id) {
        this.id = id;
    }

    public String getCarrier() {
        return carrier;
    }
    public void setCarrier(String carrier) {
        this.carrier = carrier;
    }

    // ===========================================================
    // getters and setters for the association fields

    @OneToMany(mappedBy="insurance")
    @OrderBy("firstName DESC")
    public List<Employee> getEmployees() {
        return employees;
    }
    public void setEmployees(List<Employee> employees) {
        this.employees = employees;
    }

}

