/*
 * Copyright (c) 2007, 2013, Oracle and/or its affiliates. All rights reserved.
  * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
  */

package com.sun.ts.tests.jpa.core.annotations.tableGenerator;

import javax.persistence.*;

@Entity
@Table(name = "DATATYPES")
public class DataTypes2 implements java.io.Serializable {

    private int id;

    private String stringData;

    public DataTypes2()
    {
    }

    public DataTypes2(String stringData)
    {
        this.stringData = stringData;
    }

   @Id
   @GeneratedValue(strategy = GenerationType.TABLE, generator = "myTableGenerator2")
   @TableGenerator(name = "myTableGenerator2", table="GENERATOR_TABLE",
            pkColumnName = "PK_COL", valueColumnName = "VAL_COL",
     pkColumnValue = "DT2_ID", allocationSize = 1, initialValue = 100)
   @Column(name="ID")
   public int getId()
   {
      return id;
   }
   public void setId(int id)
   {
      this.id= id;
   }
   
   @Column(name = "CHARARRAYDATA")
   public String getStringData()
   {
      return stringData;
   }
   public void setStringData(String stringData)
   {
      this.stringData = stringData;
   }
    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getSimpleName()+"[");
        result.append("id: " + getId());
        result.append(", stringData: " + getStringData());
        result.append("]");
        return result.toString();
    }
    
}
