/*
 * Copyright (c) 2008, 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.sun.ts.tests.jpa.core.annotations.version;


import javax.persistence.*;

@Entity
@Table(name = "A_BASIC")
public class Short_Property implements java.io.Serializable {

    // ===========================================================
    // instance variables

    protected String id;
    protected short basicShort;
    protected String name;

        // ===========================================================
    // constructors
    public Short_Property() {
    }

    public Short_Property(String id) {
        this.id = id;
    }

    public Short_Property(String id, short value) {
        
        this.id = id;
        this.basicShort = value;
    }

    @Id
    public String getId() {
        return id;
    }
    
    public void setId(String id){
        this.id=id;       
    }
    @Basic
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Version
    public short getBasicShort() {
        return this.basicShort;
    }

    public void setBasicShort(short value) {
        this.basicShort = value;
    }

    public boolean equals(Object o) {
        Short_Property other;
        boolean result = false;

        if (!(o instanceof Short_Property)) {
            return result;
        }
        other = (Short_Property) o;

        if (this.getId().equals(other.getId()) &&
                this.basicShort == other.basicShort &&
                this.name.equals(other.getName())
                ) {
            result = true;
        }

        return result;
    }


    public int hashCode() {
        int myHash;

        myHash = this.getId().hashCode() + this.basicShort +
                  this.name.hashCode();

        return myHash;
    }
    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getSimpleName() + "[");
        result.append("id: " + getId());
        result.append(", version: " + basicShort);
        result.append(", name: " + name);
        result.append("]");
        return result.toString();
    }
 }
