/*
 * Copyright (c) 2007, 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: A.java 65615 2012-03-29 19:02:39Z sdimilla $
 */

package com.sun.ts.tests.jpa.core.entitytest.remove.oneXmany;

import com.sun.ts.lib.util.TestUtil;

import javax.persistence.*;
import java.util.Collection;

@Entity
@Table(name="AEJB_1XM_BI_BTOB")
public class A implements java.io.Serializable {


    // ===========================================================
    // instance variables 

    @Id
    protected String id;

    @Basic
    protected String name;

    @Basic
    protected int value;


    // ===========================================================
    // constructors

    public A() {
        TestUtil.logTrace("Entity A no arg constructor");
    }

    public A(String id, String name, int value)
    {
      this.id = id;
      this.name = name;
      this.value = value;
    }

    public A(String id, String name, int value, Collection bCol)
    {
      this.id = id;
      this.name = name;
      this.value = value;
      this.bCol = bCol;
    }

    // ===========================================================
    // relationship fields

    @OneToMany(targetEntity=com.sun.ts.tests.jpa.core.entitytest.remove.oneXmany.B.class, mappedBy="a1", cascade=CascadeType.REMOVE)
    protected Collection bCol = new java.util.ArrayList();

    // =======================================================================
    // Business methods for test cases



    public Collection getBCol()
    {
        TestUtil.logTrace("getBCol");
	return bCol;
    }
    public void setBCol(Collection c)
    {
	this.bCol = c;
    }

    public String getAId()
    {   
        return id;
    }

    public String getAName()
    {
        return name;
    }

    public int getAValue()
    {
        return value;
    }

}
