/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.exec;

import com.sun.javatest.TestResult;
import com.sun.javatest.exec.BranchPanel;
import com.sun.javatest.exec.ElapsedTimeMonitor;
import com.sun.javatest.exec.MonitorState;
import com.sun.javatest.exec.ProgressMeter;
import com.sun.javatest.exec.RenderingUtilities;
import com.sun.javatest.exec.TreePanelModel;
import com.sun.javatest.tool.I18NUtils;
import com.sun.javatest.tool.ToolDialog;
import com.sun.javatest.tool.UIFactory;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.reflect.InvocationTargetException;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.border.Border;

class ProgressMonitor
extends ToolDialog {
    private MonitorState state;
    private TreePanelModel tpm;
    private ProgressSubpanel progressSubpanel;
    private ActivitySubpanel activitySubpanel;
    private TimeSubpanel timeSubpanel;
    private MemorySubpanel memorySubpanel;
    private StatusSubpanel[] subpanels;
    private volatile boolean running;
    private Listener listener = new Listener();
    private static final int UPDATE_FREQUENCY = 1000;
    private static int componentCount;

    ProgressMonitor(Component parent, UIFactory uif, MonitorState state) {
        super(parent, uif, "pm", 1);
        this.state = state;
    }

    @Override
    protected void initGUI() {
        this.setI18NTitle("pm.title");
        this.setHelp("browse.testMonitor.csh");
        this.subpanels = new StatusSubpanel[4];
        JPanel body = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.gridwidth = 2;
        c.gridx = 0;
        c.gridy = 0;
        c.insets.left = 8;
        c.insets.right = 8;
        c.insets.top = 5;
        c.weightx = 1.0;
        c.weighty = 0.0;
        this.progressSubpanel = new ProgressSubpanel();
        this.subpanels[0] = this.progressSubpanel;
        body.add((Component)this.progressSubpanel, c);
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 1;
        c.insets.right = 0;
        c.weightx = 1.0;
        c.weighty = 2.0;
        this.timeSubpanel = new TimeSubpanel();
        this.subpanels[1] = this.timeSubpanel;
        body.add((Component)this.timeSubpanel, c);
        c.gridy = 2;
        this.memorySubpanel = new MemorySubpanel();
        this.subpanels[2] = this.memorySubpanel;
        body.add((Component)this.memorySubpanel, c);
        c.fill = 1;
        c.gridheight = 2;
        c.gridwidth = 1;
        c.gridx = 1;
        c.gridy = 1;
        c.insets.right = 8;
        c.weightx = 3.0;
        c.weighty = 1.0;
        this.activitySubpanel = new ActivitySubpanel();
        this.subpanels[3] = this.activitySubpanel;
        body.add((Component)this.activitySubpanel, c);
        this.setBody(body);
        JButton helpBtn = this.uif.createHelpButton("pm.help", "browse.testMonitor.csh");
        JButton closeBtn = this.uif.createCloseButton("pm.close");
        this.setButtons(new JButton[]{helpBtn, closeBtn}, closeBtn);
        this.state.addObserver(this.listener);
        if (this.state.isRunning()) {
            this.listener.starting();
        }
        for (int i = 0; i < this.subpanels.length; ++i) {
            this.subpanels[i].update();
        }
    }

    void setTreePanelModel(TreePanelModel tpm) {
        this.tpm = tpm;
    }

    private class MemorySubpanel
    extends StatusSubpanel {
        private JTextField usedField;
        private JTextField totalField;
        private ProgressMeter meter;
        private int[] meterStats;
        private Runtime runtime;

        MemorySubpanel() {
            this.meterStats = new int[2];
            this.runtime = Runtime.getRuntime();
            this.setLayout(new GridBagLayout());
            Border b1 = ProgressMonitor.this.uif.createTitledBorder("pm.memory");
            Border b2 = BorderFactory.createEmptyBorder(10, 5, 10, 5);
            this.setBorder(BorderFactory.createCompoundBorder(b1, b2));
            GridBagConstraints lnc = new GridBagConstraints();
            lnc.gridx = 0;
            lnc.anchor = 13;
            lnc.insets.right = 10;
            lnc.weightx = 0.0;
            lnc.fill = 0;
            GridBagConstraints rc = new GridBagConstraints();
            rc.fill = 1;
            rc.gridwidth = 0;
            rc.weightx = 1.0;
            JLabel lab = ProgressMonitor.this.uif.createLabel("pm.memory.used");
            lab.setDisplayedMnemonic(ProgressMonitor.this.uif.getI18NString("pm.memory.used.mne").charAt(0));
            this.add((Component)lab, lnc);
            this.usedField = ProgressMonitor.this.uif.createOutputField("pm.memory.used", 10);
            this.add((Component)this.usedField, rc);
            lab.setLabelFor(this.usedField);
            lab = ProgressMonitor.this.uif.createLabel("pm.memory.ttl");
            lab.setDisplayedMnemonic(ProgressMonitor.this.uif.getI18NString("pm.memory.ttl.mne").charAt(0));
            this.add((Component)lab, lnc);
            this.totalField = ProgressMonitor.this.uif.createOutputField("pm.memory.ttl", 10);
            this.add((Component)this.totalField, rc);
            lab.setLabelFor(this.totalField);
            this.add(Box.createVerticalStrut(10), rc);
            ProgressMonitor.this.uif.setToolTip(this, "pm.memory");
        }

        @Override
        void update() {
            int freeMem = (int)(this.runtime.freeMemory() / 1024L);
            int totalMem = (int)(this.runtime.totalMemory() / 1024L);
            int usedMem = totalMem - freeMem;
            this.usedField.setText(usedMem + "K");
            this.totalField.setText(totalMem + "K");
        }
    }

    private class TimeSubpanel
    extends StatusSubpanel {
        private JTextField elapsedField;
        private JTextField estimatedRemainingField;
        private int[] meterStats;

        TimeSubpanel() {
            this.meterStats = new int[2];
            this.setLayout(new GridBagLayout());
            Border b1 = ProgressMonitor.this.uif.createTitledBorder("pm.time");
            Border b2 = BorderFactory.createEmptyBorder(10, 5, 10, 5);
            this.setBorder(BorderFactory.createCompoundBorder(b1, b2));
            GridBagConstraints lnc = new GridBagConstraints();
            lnc.gridx = 0;
            lnc.anchor = 13;
            lnc.insets.right = 10;
            GridBagConstraints rc = new GridBagConstraints();
            rc.fill = 1;
            rc.gridwidth = 0;
            rc.weightx = 1.0;
            JLabel lab = ProgressMonitor.this.uif.createLabel("pm.time.sofar");
            lab.setDisplayedMnemonic(ProgressMonitor.this.uif.getI18NString("pm.time.sofar.mne").charAt(0));
            this.add((Component)lab, lnc);
            this.elapsedField = ProgressMonitor.this.uif.createOutputField("pm.time.sofar", 8);
            this.add((Component)this.elapsedField, rc);
            this.elapsedField.setText("00:00:00");
            lab.setLabelFor(this.elapsedField);
            lab = ProgressMonitor.this.uif.createLabel("pm.time.remain");
            lab.setDisplayedMnemonic(ProgressMonitor.this.uif.getI18NString("pm.time.remain.mne").charAt(0));
            this.add((Component)lab, lnc);
            this.estimatedRemainingField = ProgressMonitor.this.uif.createOutputField("pm.time.remain", 8);
            this.add((Component)this.estimatedRemainingField, rc);
            this.estimatedRemainingField.setText("00:00:00");
            lab.setLabelFor(this.estimatedRemainingField);
            this.add(Box.createVerticalStrut(10), rc);
            ProgressMonitor.this.uif.setToolTip(this, "pm.time");
        }

        @Override
        void update() {
            long elapsed = ProgressMonitor.this.state.getElapsedTime();
            this.elapsedField.setText(ElapsedTimeMonitor.millisToString(elapsed));
            long remain = ProgressMonitor.this.state.getEstimatedTime();
            this.estimatedRemainingField.setText(ElapsedTimeMonitor.millisToString(remain));
        }
    }

    private class ActivitySubpanel
    extends StatusSubpanel {
        private JComponent idleCard;
        private JComponent runningCard;
        private JTextField fileField;
        private DefaultListModel testListData;
        private JList testList;
        private String rootDir;

        ActivitySubpanel() {
            this.setBorder(ProgressMonitor.this.uif.createTitledBorder("pm.activity"));
            this.setLayout(new CardLayout());
            this.idleCard = this.createSimpleCard("pm.idle");
            this.addCard(this.idleCard);
            this.initRunningCard();
            this.showCard(this.idleCard);
        }

        @Override
        void starting() {
            this.showCard(this.runningCard);
        }

        @Override
        void postProcessing() {
            this.showCard(this.idleCard);
        }

        @Override
        void stopping() {
        }

        @Override
        void update() {
            this.testListData.removeAllElements();
            TestResult[] rt = ProgressMonitor.this.state.getRunningTests();
            for (int i = 0; i < rt.length; ++i) {
                this.testListData.addElement(rt[i]);
            }
        }

        private JComponent createSimpleCard(String uiKey) {
            JPanel card = new JPanel();
            card.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.anchor = 10;
            c.gridwidth = 0;
            c.weightx = 1.0;
            c.weighty = 1.0;
            JTextField tf = ProgressMonitor.this.uif.createHeading(uiKey);
            ProgressMonitor.this.uif.setAccessibleInfo(tf, uiKey);
            card.add((Component)tf, c);
            JLabel icon = ProgressMonitor.this.uif.createIconLabel(uiKey);
            c.anchor = 17;
            c.weighty = 0.0;
            card.add((Component)icon, c);
            return card;
        }

        private void initRunningCard() {
            this.testListData = new DefaultListModel();
            final JList list = ProgressMonitor.this.uif.createList("pm.runlist", this.testListData);
            list.setBorder(BorderFactory.createEtchedBorder());
            list.setCellRenderer(RenderingUtilities.createTestListRenderer());
            list.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    int index = list.locationToIndex(e.getPoint());
                    if (index < 0) {
                        return;
                    }
                    Object target = list.getModel().getElementAt(index);
                    if (target instanceof TestResult && ProgressMonitor.this.tpm != null) {
                        ProgressMonitor.this.tpm.showTest(((TestResult)target).getTestName());
                    }
                }
            });
            this.runningCard = ProgressMonitor.this.uif.createScrollPane(list, 20, 30);
            this.addCard(this.runningCard);
        }

        private void addCard(JComponent comp) {
            String s = comp.getName();
            if (s == null) {
                comp.setName("StatusDialog.component" + componentCount++);
            }
            this.add((Component)comp, comp.getName());
        }

        private void showCard(JComponent comp) {
            ((CardLayout)this.getLayout()).show(this, comp.getName());
        }
    }

    private class ProgressSubpanel
    extends StatusSubpanel {
        private JTextField passTf;
        private JTextField failTf;
        private JTextField errorTf;
        private JTextField notRunTf;
        private ProgressMeter meter;
        private int[] meterStats;

        ProgressSubpanel() {
            this.setBorder(ProgressMonitor.this.uif.createTitledBorder("pm.prog"));
            this.setLayout(new GridBagLayout());
            GridBagConstraints lnc = new GridBagConstraints();
            lnc.gridx = 0;
            lnc.anchor = 13;
            lnc.insets.right = 10;
            GridBagConstraints lc = new GridBagConstraints();
            lc.insets.right = 5;
            GridBagConstraints fc = new GridBagConstraints();
            fc.weightx = 1.0;
            fc.fill = 2;
            fc.insets.right = 15;
            GridBagConstraints rc = new GridBagConstraints();
            rc.weightx = 1.0;
            rc.fill = 1;
            rc.gridwidth = 0;
            JTextField tf = ProgressMonitor.this.uif.createHeading("pm.tests");
            tf.setBackground(UIFactory.Colors.TRANSPARENT.getValue());
            ProgressMonitor.this.uif.setAccessibleInfo(tf, "pm.tests");
            this.add((Component)tf, lnc);
            JLabel lab = ProgressMonitor.this.uif.createLabel("pm.tests.pass");
            this.add((Component)lab, lc);
            this.passTf = ProgressMonitor.this.uif.createOutputField("pm.tests.pass", 6);
            this.passTf.setHorizontalAlignment(4);
            lab.setLabelFor(this.passTf);
            lab.setDisplayedMnemonic(ProgressMonitor.this.uif.getI18NString("pm.tests.pass.mne").charAt(0));
            this.add((Component)this.passTf, fc);
            lab = ProgressMonitor.this.uif.createLabel("pm.tests.fail");
            lab.setDisplayedMnemonic(ProgressMonitor.this.uif.getI18NString("pm.tests.fail.mne").charAt(0));
            this.add((Component)lab, lc);
            this.failTf = ProgressMonitor.this.uif.createOutputField("pm.tests.fail", 6);
            this.failTf.setHorizontalAlignment(4);
            lab.setLabelFor(this.failTf);
            this.add((Component)this.failTf, fc);
            lab = ProgressMonitor.this.uif.createLabel("pm.tests.err");
            this.add((Component)lab, lc);
            this.errorTf = ProgressMonitor.this.uif.createOutputField("pm.tests.err", 6);
            lab.setDisplayedMnemonic(ProgressMonitor.this.uif.getI18NString("pm.tests.err.mne").charAt(0));
            this.errorTf.setHorizontalAlignment(4);
            lab.setLabelFor(this.errorTf);
            this.add((Component)this.errorTf, fc);
            lab = ProgressMonitor.this.uif.createLabel("pm.tests.nr");
            lab.setDisplayedMnemonic(ProgressMonitor.this.uif.getI18NString("pm.tests.nr.mne").charAt(0));
            this.add((Component)lab, lc);
            this.notRunTf = ProgressMonitor.this.uif.createOutputField("pm.tests.nr", 6);
            this.notRunTf.setHorizontalAlignment(4);
            lab.setLabelFor(this.notRunTf);
            this.add((Component)this.notRunTf, rc);
            this.add(Box.createVerticalStrut(10), rc);
            Color[] colors = new Color[]{I18NUtils.getStatusBarColor(0), I18NUtils.getStatusBarColor(1), I18NUtils.getStatusBarColor(2), I18NUtils.getStatusBarColor(3)};
            tf = ProgressMonitor.this.uif.createHeading("pm.tests.mtr");
            ProgressMonitor.this.uif.setAccessibleInfo(tf, "pm.tests.mtr");
            this.add((Component)tf, lnc);
            this.meter = new ProgressMeter(colors, ProgressMonitor.this.state);
            this.add((Component)this.meter, rc);
            ProgressMonitor.this.uif.setAccessibleInfo(this.meter, "pm.tests.bar");
            ProgressMonitor.this.uif.setToolTip(this, "pm.tests");
        }

        @Override
        public void update() {
            this.updateAll();
        }

        private void updateAll() {
            this.meter.update();
            int[] stats = ProgressMonitor.this.state.getStats();
            this.setCount(this.passTf, stats[0]);
            this.setCount(this.failTf, stats[1]);
            this.setCount(this.errorTf, stats[2]);
            this.setCount(this.notRunTf, ProgressMonitor.this.state.getTestsRemainingCount());
        }

        private final void setCount(JTextField tf, int value) {
            if (EventQueue.isDispatchThread()) {
                tf.setText(Integer.toString(value));
            } else {
                try {
                    EventQueue.invokeAndWait(new BranchPanel.TextUpdater(tf, Integer.toString(value), ProgressMonitor.this.uif));
                }
                catch (InterruptedException e) {
                }
                catch (InvocationTargetException invocationTargetException) {
                    // empty catch block
                }
            }
        }
    }

    private abstract class StatusSubpanel
    extends JPanel {
        private StatusSubpanel() {
        }

        abstract void update();

        void starting() {
        }

        void postProcessing() {
        }

        void stopping() {
        }
    }

    class Listener
    implements MonitorState.Observer,
    ActionListener {
        private Timer timer = new Timer(1000, this);

        Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.timer) {
                for (int i = 0; i < ProgressMonitor.this.subpanels.length; ++i) {
                    ProgressMonitor.this.subpanels[i].update();
                }
            }
        }

        @Override
        public void starting() {
            ProgressMonitor.this.running = true;
            for (int i = 0; i < ProgressMonitor.this.subpanels.length; ++i) {
                ProgressMonitor.this.subpanels[i].starting();
            }
            this.timer.start();
        }

        @Override
        public void postProcessing() {
            for (int i = 0; i < ProgressMonitor.this.subpanels.length; ++i) {
                ProgressMonitor.this.subpanels[i].update();
                ProgressMonitor.this.subpanels[i].postProcessing();
            }
        }

        @Override
        public void stopping() {
        }

        @Override
        public void finished(boolean allOk) {
            ProgressMonitor.this.running = false;
            for (int i = 0; i < ProgressMonitor.this.subpanels.length; ++i) {
                ProgressMonitor.this.subpanels[i].update();
                ProgressMonitor.this.subpanels[i].stopping();
            }
            this.timer.stop();
        }
    }
}

