/*
 * Copyright (c) 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: TestServlet.java 62525 2011-04-15 12:14:31Z dougd $
 */

package com.sun.ts.tests.jsf.api.javax_faces.component.html.htmlpanelgrid;

import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.component.html.HtmlPanelGrid;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;


public final class TestServlet 
extends com.sun.ts.tests.jsf.api.javax_faces.component.uipanel.TestServlet {
    
    private static final String[] attrNames = {
        "bgcolor", "border", "cellpadding", "cellspacing", "columnClasses",
        "columns", "dir", "footerClass", "frame", "headerClass", "lang",
        "onclick", "ondblclick", "onkeydown", "onkeypress", "onkeyup",
        "onmousedown", "onmousemove", "onmouseout", "onmouseover",
        "onmouseup", "rowClasses", "rules", "style", "styleClass", "summary",
        "title", "width"
    };

    /**
     * <p>Initializes this {@link javax.servlet.Servlet}.</p>
     * 
     * @param config this Servlet's configuration
     * @throws ServletException if an error occurs
     */
    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        setRendererType("javax.faces.Grid");
        setRendersChildren(Boolean.TRUE);
        setAttributeNames(attrNames);
    }


    /**
     * <p>Creates a new {@link UIComponent} instance.</p>
     * 
     * @return a new {@link UIComponent} instance.
     */
    protected UIComponentBase createComponent() {
        return new HtmlPanelGrid();
    }
    
// ------------------------------------------- Test Methods ----

}
