/*
 * Copyright (c) 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: TestServlet.java 68235 2012-10-24 12:45:35Z dougd $
 */

package com.sun.ts.tests.jsf.api.javax_faces.context.externalcontextfactory;

import java.io.IOException;
import java.io.PrintWriter;

import javax.faces.FactoryFinder;
import javax.faces.context.ExternalContext;
import javax.faces.context.ExternalContextFactory;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.lifecycle.LifecycleFactory;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.sun.ts.tests.jsf.common.servlets.HttpTCKServlet;
import com.sun.ts.tests.jsf.common.util.JSFTestUtil;

public final class TestServlet extends HttpTCKServlet {

    ServletContext servletContext;
    Lifecycle lifecycle;

    public void init(ServletConfig config) throws ServletException {
	servletContext = config.getServletContext();
	LifecycleFactory lifeFactory = (LifecycleFactory) FactoryFinder
		.getFactory(FactoryFinder.LIFECYCLE_FACTORY);
	lifecycle = lifeFactory
		.getLifecycle(LifecycleFactory.DEFAULT_LIFECYCLE);
	super.init(config);
    }

    // ------------------------------------------- Test Methods ----

    public void externalContextFactoryGetExternalContextTest(
	    HttpServletRequest request, HttpServletResponse response)
	    throws ServletException, IOException {
	PrintWriter out = response.getWriter();

	ExternalContextFactory contextFactory = (ExternalContextFactory) FactoryFinder
		.getFactory(FactoryFinder.EXTERNAL_CONTEXT_FACTORY);

	ExternalContext context = contextFactory.getExternalContext(
		servletContext, request, response);

	if (context == null) {
	    out.println(JSFTestUtil.FAIL
		    + " Unable to obtain a FacesContext instance from"
		    + " the FacesContextFactory.");
	} else {
	    out.println(JSFTestUtil.PASS);
	}

    } // End externalContextFactoryGetExternalContextTest

    public void externalCtxFactoryGetExternalContextNPETest(
	    HttpServletRequest request, HttpServletResponse response)
	    throws ServletException, IOException {
	PrintWriter out = response.getWriter();

	ExternalContextFactory contextFactory = (ExternalContextFactory) FactoryFinder
		.getFactory(FactoryFinder.EXTERNAL_CONTEXT_FACTORY);

	// null context
	JSFTestUtil.checkForNPE(contextFactory, "getExternalContext",
		new Class<?>[] { Object.class, Object.class, Object.class },
		new Object[] { null, request, response }, out);

	// null request
	JSFTestUtil.checkForNPE(contextFactory, "getExternalContext",
		new Class<?>[] { Object.class, Object.class, Object.class },
		new Object[] { servletContext, null, response }, out);

	// null response
	JSFTestUtil.checkForNPE(contextFactory, "getExternalContext",
		new Class<?>[] { Object.class, Object.class, Object.class },
		new Object[] { servletContext, request, null }, out);

    }// End externalCtxFactoryGetExternalContextNPETest

    public void externalContextFactoryGetWrappedTest(
	    HttpServletRequest request, HttpServletResponse response)
	    throws ServletException, IOException {
	PrintWriter out = response.getWriter();

	ExternalContextFactory contextFactory = (ExternalContextFactory) FactoryFinder
		.getFactory(FactoryFinder.EXTERNAL_CONTEXT_FACTORY);

	ExternalContextFactory context = contextFactory.getWrapped();

	if (context != null) {
	    out.println(JSFTestUtil.FAIL
		    + " Unable to obtain a FacesContext instance from"
		    + " the FacesContextFactory.");
	} else {
	    out.println(JSFTestUtil.PASS);
	}

    } // End externalContextFactoryGetWrappedTest

}
