/*
 * Copyright (c) 2012, 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: URLClient.java 72231 2013-06-25 19:28:28Z dougd $
 */

package com.sun.ts.tests.jsf.api.javax_faces.event.phaseevent;

import java.io.PrintWriter;

import com.sun.javatest.Status;
import com.sun.ts.tests.jsf.common.client.AbstractUrlClient;

public class URLClient extends AbstractUrlClient {

	private static final String CONTEXT_ROOT = "/jsf_event_phaseevent_web";

	public static void main(String[] args) {
		URLClient theTests = new URLClient();
		Status s = theTests.run(args, new PrintWriter(System.out),
				new PrintWriter(System.err));
		s.exit();
	}

	public Status run(String args[], PrintWriter out, PrintWriter err) {
		setContextRoot(CONTEXT_ROOT);
		setServletName(DEFAULT_SERVLET_NAME);
		return super.run(args, out, err);
	}

	/*
	 * @class.setup_props: webServerHost; webServerPort; ts_home;
	 */

	// ----------------------------------- Tests

	/**
	 * @testName: phaseEventGetPhaseIdTest
	 * @assertion_ids: JSF:JAVADOC:1845; JSF:JAVADOC:1844
	 * @test_Strategy: Validate that we receive the correct value from
	 *                 javax.faces.event.PhaseEvent.getPhaseId().
	 */
	public void phaseEventGetPhaseIdTest() throws Fault {
		TEST_PROPS.setProperty(APITEST, "phaseEventGetPhaseIdTest");
		invoke();
	}

	/**
	 * @testName: phaseEventGetFacesContextTest
	 * @assertion_ids: JSF:JAVADOC:1845; JSF:JAVADOC:1843
	 * @test_Strategy: Validate that we receive the correct value from
	 *                 javax.faces.event.PhaseEvent.getFacesContext().
	 */
	public void phaseEventGetFacesContextTest() throws Fault {
		TEST_PROPS.setProperty(APITEST, "phaseEventGetFacesContextTest");
		invoke();
	}
}
