/*
 * Copyright (c) 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: TestServlet.java 63987 2011-11-04 18:50:14Z dougd $
 */
package com.sun.ts.tests.jsf.api.javax_faces.factoryfinder.metainf;

import com.sun.ts.tests.jsf.common.servlets.FactoryTCKServlet;
import javax.faces.FactoryFinder;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import java.io.IOException;
import java.io.PrintWriter;
import javax.faces.context.FacesContextFactory;

public class TestServlet extends FactoryTCKServlet {

    public void getFactoryMetainfTest(
            HttpServletRequest request, HttpServletResponse response)
            throws ServletException, IOException {
        PrintWriter pw = response.getWriter();

        String factory = "com.sun.ts.tests.jsf.common.factories." +
                "TCKContextFactory";
        try {

            FacesContextFactory fcf = (FacesContextFactory)
                    FactoryFinder.getFactory(
                    FactoryFinder.FACES_CONTEXT_FACTORY);

            String factName = fcf.getWrapped().getClass().getCanonicalName();

            if (factName.contains("TCKContextFactory")) {
                pw.println("Test PASSED");
            } else {
                pw.println("Wrong FacesContextFactory Being Used");
                pw.println("Found: " + FactoryFinder.getFactory(
                        FactoryFinder.FACES_CONTEXT_FACTORY).toString());
                pw.println("Expected: " + factory);
                pw.println("Test FAILED.");
            }

        } catch (Exception e) {
            pw.println("Test FAILED.");
            pw.println(e.toString());
        }
    }
}