/*
 * Copyright (c) 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: TestServlet.java 64095 2011-11-23 14:59:12Z dougd $
 */

package com.sun.ts.tests.jsf.api.javax_faces.factoryfinderrelease;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jsf.common.servlets.HttpTCKServlet;
import com.sun.ts.tests.jsf.common.util.JSFTestUtil;

import javax.faces.FactoryFinder;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import java.io.IOException;
import java.io.PrintWriter;

public class TestServlet extends HttpTCKServlet {
	public void getFactoriesISETest(HttpServletRequest request,
            HttpServletResponse response)
            throws ServletException, IOException {
        // release the factory instances allocated in the getFactoryTest
        PrintWriter pw = response.getWriter();
        try {
            FactoryFinder.releaseFactories();
            FactoryFinder.getFactory(FactoryFinder.APPLICATION_FACTORY);
            pw.println("Test FAILED" + JSFTestUtil.NL + "Expected an " +
            		"IllegalStateException to be thrown, no Exception thrown " +
            		"at all!.");
        } catch (IllegalStateException ise) {
        	pw.println(JSFTestUtil.PASS);
        	
        } catch (Exception e) {	
            pw.println("Test FAILED" + JSFTestUtil.NL + "Unexpected Exception thrown!" + 
            		JSFTestUtil.NL + "Expected: IllegalStateException" + JSFTestUtil.NL +
            		"Received: " + JSFTestUtil.NL + e.toString());
        }
    }

}
