/*
 * Copyright (c) 2009, 2013. Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: URLClient.java 72233 2013-06-26 14:10:08Z dougd $
 */
package com.sun.ts.tests.jsf.api.javax_faces.factoryfinderrelease;

import com.sun.javatest.Status;
import com.sun.ts.tests.jsf.common.client.AbstractUrlClient;

import java.io.PrintWriter;

public class URLClient extends AbstractUrlClient {

	private static final String CONTEXT_ROOT = "/jsf_factoryfinderrelease_web";

	public static void main(String[] args) {
		URLClient theTests = new URLClient();
		Status s = theTests.run(args, new PrintWriter(System.out),
				new PrintWriter(System.err));
		s.exit();
	}

	public Status run(String args[], PrintWriter out, PrintWriter err) {
		setContextRoot(CONTEXT_ROOT);
		setServletName(DEFAULT_SERVLET_NAME);
		return super.run(args, out, err);
	}

	/*
	 * @class.setup_props: webServerHost; webServerPort; ts_home;
	 */

	/* Run test */

	/**
	 * @testName: getFactoriesISETest
	 * @assertion_ids: JSF:JAVADOC:10; JSF:JAVADOC:12
	 * @test_Strategy: Validate FactoryFinder.getFactory() throws an
	 *                 IllegalStateException when no factories are configured
	 *                 when call is made. We call the Factory.releaseFactories()
	 *                 method prior to the getFactory call made above.
	 */
	public void getFactoriesISETest() throws Fault {
		TEST_PROPS.setProperty(APITEST, "getFactoriesISETest");
		invoke();
	}
}
