/*
 * Copyright (c) 2009, 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: URLClient.java 68272 2012-10-25 12:55:14Z dougd $
 */

package com.sun.ts.tests.jsf.api.javax_faces.model.datamodelevent;

import java.io.PrintWriter;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.tests.jsf.common.client.AbstractUrlClient;

public final class URLClient extends AbstractUrlClient {

    private static final String CONTEXT_ROOT = "/jsf_model_dmevent_web";

    public static void main(String[] args) {
	URLClient theTests = new URLClient();
	Status s = theTests.run(args, new PrintWriter(System.out, true),
		new PrintWriter(System.err, true));
	s.exit();
    }

    public Status run(String[] args, PrintWriter out, PrintWriter err) {
	setContextRoot(CONTEXT_ROOT);
	setServletName(DEFAULT_SERVLET_NAME);
	return super.run(args, out, err);
    }

    /*
     * @class.setup_props: webServerHost; webServerPort; ts_home;
     */

    /* Test Declarations */

    /**
     * @testName: dataModelEventTest
     * @assertion_ids: JSF:JAVADOC:1932; JSF:JAVADOC:1936; JSF:JAVADOC:1945;
     *                 JSF:JAVADOC:1939
     * @test_Strategy: Validate the getRowData(), getDataModel(), and
     *                 getRowIndex() methods return the values passed to the
     *                 ctor of DataModelEvent.
     */
    public void dataModelEventTest() throws Fault {
	TEST_PROPS.setProperty(APITEST, "dataModelEventTest");
	invoke();
    }

} // end of URLClient
