/*
 * Copyright (c) 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: PartialStateHolderTestServlet.java 64095 2011-11-23 14:59:12Z dougd $
 */
package com.sun.ts.tests.jsf.api.javax_faces.validator.common;

import java.io.IOException;
import java.io.PrintWriter;

import javax.faces.component.PartialStateHolder;
import javax.faces.component.StateHolder;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.sun.ts.tests.jsf.common.util.JSFTestUtil;

/**
 * <p>
 * Base test Servlet for the {@link PartialStateHolder} interface.
 * </p>
 */
public abstract class PartialStateHolderTestServlet extends
		BaseStateHolderTestServlet {

	// ----------------------------------------------------------- Public
	// Methods
	/**
	 * <p>
	 * Initializes this {@link javax.servlet.Servlet}.
	 * </p>
	 * 
	 * @param config
	 *            this Servlet's configuration
	 * @throws ServletException
	 *             if an error occurs
	 */
	public void init(ServletConfig config) throws ServletException {
		super.init(config);
	}

	// ----------------------------------------------------------- Test Methods
	public void validatorPartialStateTest(
			HttpServletRequest request, HttpServletResponse response)
			throws ServletException, IOException {
		PrintWriter out = response.getWriter();
		
		PartialStateHolder psh;
		if(createValidator() instanceof PartialStateHolder){
			psh = (PartialStateHolder) createValidator();
		} else {
        	out.println("The Specific Validator that you are trying to test " +
			"does not implement the PartialStateHolder interface!");
        	return;			
		}

		boolean result;
		
		// Expect state is 'true'.
		psh.markInitialState();
		result = psh.initialStateMarked();
		if (result) {
			// do nothing test status still true.
		} else {
			out.println("Test FAILED." + JSFTestUtil.NL + 
					"Unexpected state returned when calling " +
					"initialStateMarked after markInitialState() was " +
					"called" + JSFTestUtil.NL +
					"Expected: true" + JSFTestUtil.NL +
					"Received: " + result);
			return;
		}
		
		// Expect state to be 'false'
		psh.clearInitialState();
		result = psh.initialStateMarked();
		if (!result) {
			// do nothing test status still true.
		} else {
			out.println("Test FAILED." + JSFTestUtil.NL + 
					"Unexpected state returned when calling " +
					"IntialStateMarked() after clearInitialState() was " +
					"called" + JSFTestUtil.NL +
					"Expected: false" + JSFTestUtil.NL +
					"Received: " + result);
			return;
		}
		
		out.println(JSFTestUtil.PASS);
	}
}
