/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: MaintainCustomerRecordJavaFlowDefinition.java 70341 2013-02-28 16:38:09Z dougd $
 */

package com.sun.ts.tests.jsf.spec.flows.intermediate.beans;

import java.io.Serializable;
import javax.enterprise.inject.Produces;
import javax.faces.flow.Flow;
import javax.faces.flow.builder.FlowBuilder;
import javax.faces.flow.builder.FlowDefinition;
import javax.faces.flow.builder.FlowBuilderParameter;


public class MaintainCustomerRecordJavaFlowDefinition implements Serializable {
    
    private static final long serialVersionUID = -5610441904980215032L;

    public MaintainCustomerRecordJavaFlowDefinition() {
    }
    
    @Produces @FlowDefinition
    public Flow defineFlow(@FlowBuilderParameter FlowBuilder flowBuilder) {
        String flowId = "maintain-customer-record-java";
        flowBuilder.id("", flowId);
        flowBuilder.viewNode(flowId, "/" + flowId + "/" + flowId + ".xhtml");

        flowBuilder.switchNode("router1").markAsStartNode().defaultOutcome("view-customer").
                switchCase().condition("#{flowScope.customerId == null}").
                fromOutcome("create-customer");
        flowBuilder.viewNode("create-customer", "/" + flowId + "/" + "create-customer.xhtml");
        flowBuilder.viewNode("view-customer", "/" + flowId + "/" + "view-customer.xhtml");
        flowBuilder.viewNode("maintain-customer-record", "/" + flowId + "/" + "maintain-customer-record");
        flowBuilder.methodCallNode("upgrade-customer").expression("#{maintainCustomerBeanJava.upgradeCustomer}").
                defaultOutcome("view-customer");
        flowBuilder.initializer("#{maintainCustomerBeanJava.initializeFlow}");
        flowBuilder.finalizer("#{maintainCustomerBeanJava.cleanUpFlow}");
        flowBuilder.returnNode("success").fromOutcome("/complete");
        flowBuilder.returnNode("errorOccurred").fromOutcome("error");
        
        return flowBuilder.getFlow();
    }
    
}
