/*
 * Copyright (c) 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: TestFilter.java 62525 2011-04-15 12:14:31Z dougd $
 */
package com.sun.ts.tests.jsf.spec.navigation;

import javax.servlet.Filter;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.FilterChain;
import javax.servlet.http.HttpServletResponse;

import java.io.IOException;

public class TestFilter implements Filter {

    // --------------------------------------- Methods from javax.servlet.Filter

    public void init(FilterConfig filterConfig) throws ServletException {

        System.out.println("[TestFilter] init");

    } // END init


    public void doFilter(ServletRequest servletRequest,
                         ServletResponse servletResponse,
                         FilterChain filterChain)
    throws IOException, ServletException {

        TestServletResponseWrapper wrapper =
            new TestServletResponseWrapper((HttpServletResponse) servletResponse);
        filterChain.doFilter(servletRequest, wrapper);

    } // END doFilter


    public void destroy() {

        System.out.println("[TestFilter] destroy");

    } // END destroy

}
