/*
 * Copyright (c) 2017, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id$
 */

package com.sun.ts.tests.jsonb.api.model;

import java.lang.reflect.Type;

import javax.json.bind.serializer.DeserializationContext;
import javax.json.bind.serializer.JsonbDeserializer;
import javax.json.stream.JsonParser;

public class SimpleContainerDeserializer implements JsonbDeserializer<SimpleContainer> {
    public SimpleContainer deserialize(JsonParser jsonParser, DeserializationContext deserializationContext, Type type) {
        SimpleContainer container = new SimpleContainer();

        while (jsonParser.hasNext()) {
            JsonParser.Event event = jsonParser.next();
            if (event == JsonParser.Event.START_OBJECT) {
                continue;
            }
            if (event == JsonParser.Event.END_OBJECT) {
                break;
            }
            if (event == JsonParser.Event.KEY_NAME) {
                switch (jsonParser.getString()) {
                    case "instance":
                        container.setInstance(deserializationContext.deserialize(String.class, jsonParser) + " Deserialized");
                        break;
                }
            }
        }

        return container;
    }
}
