/*
 * Copyright (c) 2017, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id$
 */

package com.sun.ts.tests.jsonb.customizedmapping.instantiation.model;

import javax.json.bind.annotation.JsonbCreator;
import javax.json.bind.annotation.JsonbProperty;

public class SimpleCreatorRenameContainer {
    private String stringInstance;
    private Integer integerInstance;
    private float floatInstance;

    @JsonbCreator
    public SimpleCreatorRenameContainer(@JsonbProperty("stringInstance") String stringInstance,
                                        @JsonbProperty("intInstance") Integer integerInstance,
                                        @JsonbProperty("floatInstance")  float floatInstance) {
        this.stringInstance = "Constructor String";
        this.integerInstance = integerInstance;
        this.floatInstance = 2;
    }

    public String getStringInstance() {
        return stringInstance;
    }

    public Integer getIntegerInstance() {
        return integerInstance;
    }

    public float getFloatInstance() {
        return floatInstance;
    }
}
