/*
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.sun.ts.tests.jsp.api.javax_el.mapelresolver;

import com.sun.ts.tests.common.el.api.resolver.ResolverTest;
import com.sun.ts.tests.jsp.common.util.JspTestUtil;
import javax.el.ELContext;
import javax.el.MapELResolver;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.SimpleTagSupport;
import java.util.HashMap;
import java.io.IOException;

public class MapELResolverTag extends SimpleTagSupport {

    public void doTag() throws JspException, IOException {

        StringBuffer buf = new StringBuffer();
        HashMap sportstars = new HashMap();
        sportstars.put("baseball", "Barry Bonds"); 
        sportstars.put("football", "Joe Montana"); 
        sportstars.put("basketball", "Michael Jordan"); 
        JspWriter out = getJspContext().getOut();
        ELContext context = getJspContext().getELContext();
        MapELResolver mapResolver = new MapELResolver(); 

        try {
            boolean pass = ResolverTest.testELResolver(context,
                    mapResolver, sportstars, "football", 
                    "Steve Young", buf, false);
            out.println(buf.toString());
            if (pass == true) out.println("Test PASSED");
        } catch (Throwable t) {
            out.println("buffer is " + buf.toString());
            JspTestUtil.handleThrowable(t, out, "MapELResolverTag");
        }
    }
}
