/*
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.sun.ts.tests.jsp.api.javax_el.resourcebundleelresolver;

import com.sun.ts.tests.common.el.api.resolver.ResolverTest;
import com.sun.ts.tests.jsp.common.util.JspTestUtil;
import javax.el.ELContext;
import javax.el.ResourceBundleELResolver;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.SimpleTagSupport;
import java.io.IOException;
import java.util.ResourceBundle;
import java.util.Enumeration;
import java.util.StringTokenizer;

public class ResourceBundleELResolverTag extends SimpleTagSupport {

    public void doTag() throws JspException, IOException {

        StringBuffer buf = new StringBuffer();

        JspWriter out = getJspContext().getOut();
        ELContext context = getJspContext().getELContext();
        ResourceBundleELResolver resourceBundleResolver = new ResourceBundleELResolver(); 
        ResourceBundle resources = new MyResources();

        try {
            boolean pass = ResolverTest.testELResolver(context,
                    resourceBundleResolver, resources, "okKey", "all right!", buf, true);
            out.println(buf.toString());
            if (pass == true) out.println("Test PASSED");
        } catch (Throwable t) {
            out.println("buffer is " + buf.toString());
            JspTestUtil.handleThrowable(t, out, "ResourceBundleELResolverTag");
        }
    }

    static class MyResources extends ResourceBundle {
	
        public Object handleGetObject(String key) {
            if (key.equals("okKey")) return "Ok";
            if (key.equals("cancelKey")) return "Cancel";
            return null;
        }

        public Enumeration getKeys() {
            return new StringTokenizer("okKey cancelKey");
        }
    }
}
