/*
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.sun.ts.tests.jsp.api.javax_el.valexpression;

import com.sun.ts.tests.jsp.common.util.JspTestUtil;
import com.sun.ts.tests.common.el.api.expression.ExpressionTest;
import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.servlet.jsp.*;
import javax.servlet.jsp.tagext.*;
import java.io.IOException;

public class ValueExpressionTag extends SimpleTagSupport {

    private ValueExpression vexp;
    private static final String VALUE = "bar";
    private static final boolean READONLY = false;
    private static final boolean LITERAL_TEXT = false;

    public void setValExpr(ValueExpression vexp) {
        this.vexp = vexp;
    }

    public void doTag() throws JspException, IOException {

        ELContext elContext = getJspContext().getELContext();
        StringBuffer buf = new StringBuffer("");
        JspWriter out = getJspContext().getOut();

        try {
            boolean pass = ExpressionTest.testValueExpression(
                    vexp, elContext, "#{foo}", String.class, 
		    VALUE, READONLY, LITERAL_TEXT, buf);
            out.println(buf.toString());
            if (pass) out.println("Test PASSED.");
            else out.println("Test FAILED.");
        } catch (Throwable t) {
            out.println(buf.toString());
            JspTestUtil.handleThrowable(t, out, "ValueExpressionTag");
        }
    }
}
