/*
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: MultiTwoTag.java 62554 2011-04-15 18:08:28Z dougd $
 */

package com.sun.ts.tests.jsp.api.javax_servlet.jsp.tagext.jspidconsumer;

import com.sun.ts.tests.jsp.common.util.JspTestUtil;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.JspIdConsumer;
import javax.servlet.jsp.tagext.SimpleTagSupport;
import java.io.IOException;

public class MultiTwoTag extends SimpleTagSupport 
        implements JspIdConsumer {

    private static String jspId;
    private JspWriter out;
 
    public void setJspId(String id) {
        jspId = id;
    }

    public static String getJspId() {
        return jspId;
    }

    public void doTag() throws JspException, IOException {

        out = getJspContext().getOut();

        try {
            out.println("MultiTwoTag: JspId is " + jspId);
        } catch (Throwable t) {
            JspTestUtil.handleThrowable(t, out, "MultiTwoTag");
        }
    }
}
